@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Namespace resource.
 * @property id Fully qualified identifier of the resource.
 * @property identity Identity information for the Namespace resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property isZoneRedundant Allows the user to specify if the service is zone-redundant. This is a required property and user needs to specify this value explicitly.
 * Once specified, this property cannot be updated.
 * @property location Location of the resource.
 * @property minimumTlsVersionAllowed Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
 * @property name Name of the resource.
 * @property privateEndpointConnections
 * @property provisioningState Provisioning state of the namespace resource.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
 * @property sku Represents available Sku pricing tiers.
 * @property systemData The system metadata relating to the namespace resource.
 * @property tags Tags of the resource.
 * @property topicSpacesConfiguration Topic spaces configuration information for the namespace resource
 * @property topicsConfiguration Topics configuration information for the namespace resource
 * @property type Type of the resource.
 */
public data class GetNamespaceResult(
    public val id: String,
    public val identity: IdentityInfoResponse? = null,
    public val inboundIpRules: List<InboundIpRuleResponse>? = null,
    public val isZoneRedundant: Boolean? = null,
    public val location: String,
    public val minimumTlsVersionAllowed: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sku: NamespaceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val topicSpacesConfiguration: TopicSpacesConfigurationResponse? = null,
    public val topicsConfiguration: TopicsConfigurationResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetNamespaceResult):
            GetNamespaceResult = GetNamespaceResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inboundIpRules = javaType.inboundIpRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin(args0)
                })
            }),
            isZoneRedundant = javaType.isZoneRedundant().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            minimumTlsVersionAllowed = javaType.minimumTlsVersionAllowed().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.NamespaceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            topicSpacesConfiguration = javaType.topicSpacesConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicSpacesConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            topicsConfiguration = javaType.topicsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
