@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Partner configuration information
 * @property id Fully qualified identifier of the resource.
 * @property location Location of the resource.
 * @property name Name of the resource.
 * @property partnerAuthorization The details of authorized partners.
 * @property provisioningState Provisioning state of the partner configuration.
 * @property systemData The system metadata relating to partner configuration resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetPartnerConfigurationResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val partnerAuthorization: PartnerAuthorizationResponse? = null,
    public val provisioningState: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPartnerConfigurationResult):
            GetPartnerConfigurationResult = GetPartnerConfigurationResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerAuthorization = javaType.partnerAuthorization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerAuthorizationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
