@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * EventGrid Topic
 * @property dataResidencyBoundary Data Residency Boundary of the resource.
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic.
 * @property endpoint Endpoint for the topic.
 * @property id Fully qualified identifier of the resource.
 * @property identity Identity information for the resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property inputSchema This determines the format that Event Grid should expect for incoming events published to the topic.
 * @property inputSchemaMapping This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
 * @property location Location of the resource.
 * @property metricResourceId Metric resource id for the topic.
 * @property name Name of the resource.
 * @property privateEndpointConnections
 * @property provisioningState Provisioning state of the topic.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
 * @property systemData The system metadata relating to Topic resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetTopicResult(
    public val dataResidencyBoundary: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val endpoint: String,
    public val id: String,
    public val identity: IdentityInfoResponse? = null,
    public val inboundIpRules: List<InboundIpRuleResponse>? = null,
    public val inputSchema: String? = null,
    public val inputSchemaMapping: JsonInputSchemaMappingResponse? = null,
    public val location: String,
    public val metricResourceId: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetTopicResult):
            GetTopicResult = GetTopicResult(
            dataResidencyBoundary = javaType.dataResidencyBoundary().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inboundIpRules = javaType.inboundIpRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin(args0)
                })
            }),
            inputSchema = javaType.inputSchema().map({ args0 -> args0 }).orElse(null),
            inputSchemaMapping = javaType.inputSchemaMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            metricResourceId = javaType.metricResourceId(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
