@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the corresponding partner topic of a Channel.
 * @property azureSubscriptionId Azure subscription ID of the subscriber. The partner topic associated with the channel will be
 * created under this Azure subscription.
 * @property eventTypeInfo Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
 * subscriber to view different types of events that are published.
 * @property name Name of the partner topic associated with the channel.
 * @property resourceGroupName Azure Resource Group of the subscriber. The partner topic associated with the channel will be
 * created under this resource group.
 * @property source The source information is provided by the publisher to determine the scope or context from which the events
 * are originating. This information can be used by the subscriber during the approval process of the
 * created partner topic.
 */
public data class PartnerTopicInfoResponse(
    public val azureSubscriptionId: String? = null,
    public val eventTypeInfo: EventTypeInfoResponse? = null,
    public val name: String? = null,
    public val resourceGroupName: String? = null,
    public val source: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.PartnerTopicInfoResponse):
            PartnerTopicInfoResponse = PartnerTopicInfoResponse(
            azureSubscriptionId = javaType.azureSubscriptionId().map({ args0 -> args0 }).orElse(null),
            eventTypeInfo = javaType.eventTypeInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.EventTypeInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
        )
    }
}
