@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Static delivery attribute mapping details.
 * @property isSecret Boolean flag to tell if the attribute contains sensitive information .
 * @property name Name of the delivery attribute or header.
 * @property type Type of the delivery attribute or header name.
 * Expected value is 'Static'.
 * @property value Value of the delivery attribute.
 */
public data class StaticDeliveryAttributeMappingResponse(
    public val isSecret: Boolean? = null,
    public val name: String? = null,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.StaticDeliveryAttributeMappingResponse):
            StaticDeliveryAttributeMappingResponse = StaticDeliveryAttributeMappingResponse(
            isSecret = javaType.isSecret().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
