@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Static routing enrichment key.
 * @property valueType Static routing enrichment value type. For e.g. this property value can be 'String'.
 */
public data class StaticRoutingEnrichmentResponse(
    public val key: String? = null,
    public val valueType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.StaticRoutingEnrichmentResponse):
            StaticRoutingEnrichmentResponse = StaticRoutingEnrichmentResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            valueType = javaType.valueType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
