@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.kotlin.outputs.CaptureDescriptionResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.RetentionDescriptionResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.eventhub.kotlin.outputs.CaptureDescriptionResponse.Companion.toKotlin as captureDescriptionResponseToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.RetentionDescriptionResponse.Companion.toKotlin as retentionDescriptionResponseToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EventHub].
 */
@PulumiTagMarker
public class EventHubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventHubArgs = EventHubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventHubArgsBuilder.() -> Unit) {
        val builder = EventHubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventHub {
        val builtJavaResource = com.pulumi.azurenative.eventhub.EventHub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventHub(builtJavaResource)
    }
}

/**
 * Single item in List or Get Event Hub operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### EventHubCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHub = new AzureNative.EventHub.EventHub("eventHub", new()
 *     {
 *         CaptureDescription = new AzureNative.EventHub.Inputs.CaptureDescriptionArgs
 *         {
 *             Destination = new AzureNative.EventHub.Inputs.DestinationArgs
 *             {
 *                 ArchiveNameFormat = "{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}",
 *                 BlobContainer = "container",
 *                 Name = "EventHubArchive.AzureBlockBlob",
 *                 StorageAccountResourceId = "/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage",
 *             },
 *             Enabled = true,
 *             Encoding = AzureNative.EventHub.EncodingCaptureDescription.Avro,
 *             IntervalInSeconds = 120,
 *             SizeLimitInBytes = 10485763,
 *         },
 *         EventHubName = "sdk-EventHub-6547",
 *         MessageRetentionInDays = 4,
 *         NamespaceName = "sdk-Namespace-5357",
 *         PartitionCount = 4,
 *         ResourceGroupName = "Default-NotificationHubs-AustraliaEast",
 *         RetentionDescription = new AzureNative.EventHub.Inputs.RetentionDescriptionArgs
 *         {
 *             CleanupPolicy = AzureNative.EventHub.CleanupPolicyRetentionDescription.Compact,
 *             RetentionTimeInHours = 96,
 *             TombstoneRetentionTimeInHours = 1,
 *         },
 *         Status = AzureNative.EventHub.EntityStatus.Active,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewEventHub(ctx, "eventHub", &eventhub.EventHubArgs{
 * 			CaptureDescription: &eventhub.CaptureDescriptionArgs{
 * 				Destination: &eventhub.DestinationArgs{
 * 					ArchiveNameFormat:        pulumi.String("{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}"),
 * 					BlobContainer:            pulumi.String("container"),
 * 					Name:                     pulumi.String("EventHubArchive.AzureBlockBlob"),
 * 					StorageAccountResourceId: pulumi.String("/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage"),
 * 				},
 * 				Enabled:           pulumi.Bool(true),
 * 				Encoding:          eventhub.EncodingCaptureDescriptionAvro,
 * 				IntervalInSeconds: pulumi.Int(120),
 * 				SizeLimitInBytes:  pulumi.Int(10485763),
 * 			},
 * 			EventHubName:           pulumi.String("sdk-EventHub-6547"),
 * 			MessageRetentionInDays: pulumi.Float64(4),
 * 			NamespaceName:          pulumi.String("sdk-Namespace-5357"),
 * 			PartitionCount:         pulumi.Float64(4),
 * 			ResourceGroupName:      pulumi.String("Default-NotificationHubs-AustraliaEast"),
 * 			RetentionDescription: &eventhub.RetentionDescriptionArgs{
 * 				CleanupPolicy:                 pulumi.String(eventhub.CleanupPolicyRetentionDescriptionCompact),
 * 				RetentionTimeInHours:          pulumi.Float64(96),
 * 				TombstoneRetentionTimeInHours: pulumi.Int(1),
 * 			},
 * 			Status: eventhub.EntityStatusActive,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.EventHub;
 * import com.pulumi.azurenative.eventhub.EventHubArgs;
 * import com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs;
 * import com.pulumi.azurenative.eventhub.inputs.DestinationArgs;
 * import com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHub = new EventHub("eventHub", EventHubArgs.builder()
 *             .captureDescription(CaptureDescriptionArgs.builder()
 *                 .destination(DestinationArgs.builder()
 *                     .archiveNameFormat("{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}")
 *                     .blobContainer("container")
 *                     .name("EventHubArchive.AzureBlockBlob")
 *                     .storageAccountResourceId("/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage")
 *                     .build())
 *                 .enabled(true)
 *                 .encoding("Avro")
 *                 .intervalInSeconds(120)
 *                 .sizeLimitInBytes(10485763)
 *                 .build())
 *             .eventHubName("sdk-EventHub-6547")
 *             .messageRetentionInDays(4)
 *             .namespaceName("sdk-Namespace-5357")
 *             .partitionCount(4)
 *             .resourceGroupName("Default-NotificationHubs-AustraliaEast")
 *             .retentionDescription(RetentionDescriptionArgs.builder()
 *                 .cleanupPolicy("Compact")
 *                 .retentionTimeInHours(96)
 *                 .tombstoneRetentionTimeInHours(1)
 *                 .build())
 *             .status("Active")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:EventHub sdk-EventHub-10 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}
 * ```
 */
public class EventHub internal constructor(
    override val javaResource: com.pulumi.azurenative.eventhub.EventHub,
) : KotlinCustomResource(javaResource, EventHubMapper) {
    /**
     * Properties of capture description
     */
    public val captureDescription: Output<CaptureDescriptionResponse>?
        get() = javaResource.captureDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> captureDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Exact time the Event Hub was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Number of days to retain the events for this Event Hub, value should be 1 to 7 days
     */
    public val messageRetentionInDays: Output<Double>?
        get() = javaResource.messageRetentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
     */
    public val partitionCount: Output<Double>?
        get() = javaResource.partitionCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Current number of shards on the Event Hub.
     */
    public val partitionIds: Output<List<String>>
        get() = javaResource.partitionIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Event Hub retention settings
     */
    public val retentionDescription: Output<RetentionDescriptionResponse>?
        get() = javaResource.retentionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> retentionDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Enumerates the possible values for the status of the Event Hub.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The exact time the message was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object EventHubMapper : ResourceMapper<EventHub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventhub.EventHub::class == javaResource::class

    override fun map(javaResource: Resource): EventHub = EventHub(
        javaResource as
            com.pulumi.azurenative.eventhub.EventHub,
    )
}

/**
 * @see [EventHub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventHub].
 */
public suspend fun eventHub(name: String, block: suspend EventHubResourceBuilder.() -> Unit):
    EventHub {
    val builder = EventHubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventHub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventHub(name: String): EventHub {
    val builder = EventHubResourceBuilder()
    builder.name(name)
    return builder.build()
}
