@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NamespaceAuthorizationRule].
 */
@PulumiTagMarker
public class NamespaceAuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceAuthorizationRuleArgs = NamespaceAuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceAuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = NamespaceAuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NamespaceAuthorizationRule {
        val builtJavaResource =
            com.pulumi.azurenative.eventhub.NamespaceAuthorizationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceAuthorizationRule(builtJavaResource)
    }
}

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### NameSpaceAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceAuthorizationRule = new AzureNative.EventHub.NamespaceAuthorizationRule("namespaceAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-Authrules-1746",
 *         NamespaceName = "sdk-Namespace-2702",
 *         ResourceGroupName = "ArunMonocle",
 *         Rights = new[]
 *         {
 *             AzureNative.EventHub.AccessRights.Listen,
 *             AzureNative.EventHub.AccessRights.Send,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewNamespaceAuthorizationRule(ctx, "namespaceAuthorizationRule", &eventhub.NamespaceAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-Authrules-1746"),
 * 			NamespaceName:         pulumi.String("sdk-Namespace-2702"),
 * 			ResourceGroupName:     pulumi.String("ArunMonocle"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String(eventhub.AccessRightsListen),
 * 				pulumi.String(eventhub.AccessRightsSend),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.NamespaceAuthorizationRule;
 * import com.pulumi.azurenative.eventhub.NamespaceAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceAuthorizationRule = new NamespaceAuthorizationRule("namespaceAuthorizationRule", NamespaceAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-Authrules-1746")
 *             .namespaceName("sdk-Namespace-2702")
 *             .resourceGroupName("ArunMonocle")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:NamespaceAuthorizationRule sdk-Authrules-1746 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}
 * ```
 */
public class NamespaceAuthorizationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.eventhub.NamespaceAuthorizationRule,
) : KotlinCustomResource(javaResource, NamespaceAuthorizationRuleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The rights associated with the rule.
     */
    public val rights: Output<List<String>>
        get() = javaResource.rights().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceAuthorizationRuleMapper : ResourceMapper<NamespaceAuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventhub.NamespaceAuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceAuthorizationRule =
        NamespaceAuthorizationRule(
            javaResource as
                com.pulumi.azurenative.eventhub.NamespaceAuthorizationRule,
        )
}

/**
 * @see [NamespaceAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceAuthorizationRule].
 */
public suspend fun namespaceAuthorizationRule(
    name: String,
    block: suspend NamespaceAuthorizationRuleResourceBuilder.() -> Unit,
):
    NamespaceAuthorizationRule {
    val builder = NamespaceAuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceAuthorizationRule(name: String): NamespaceAuthorizationRule {
    val builder = NamespaceAuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
