@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.SchemaRegistryArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.SchemaCompatibility
import com.pulumi.azurenative.eventhub.kotlin.enums.SchemaType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Single item in List or Get Schema Group operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### SchemaRegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schemaRegistry = new AzureNative.EventHub.SchemaRegistry("schemaRegistry", new()
 *     {
 *         GroupProperties = null,
 *         NamespaceName = "ali-ua-test-eh-system-1",
 *         ResourceGroupName = "alitest",
 *         SchemaCompatibility = AzureNative.EventHub.SchemaCompatibility.Forward,
 *         SchemaGroupName = "testSchemaGroup1",
 *         SchemaType = AzureNative.EventHub.SchemaType.Avro,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewSchemaRegistry(ctx, "schemaRegistry", &eventhub.SchemaRegistryArgs{
 * 			GroupProperties:     nil,
 * 			NamespaceName:       pulumi.String("ali-ua-test-eh-system-1"),
 * 			ResourceGroupName:   pulumi.String("alitest"),
 * 			SchemaCompatibility: pulumi.String(eventhub.SchemaCompatibilityForward),
 * 			SchemaGroupName:     pulumi.String("testSchemaGroup1"),
 * 			SchemaType:          pulumi.String(eventhub.SchemaTypeAvro),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.SchemaRegistry;
 * import com.pulumi.azurenative.eventhub.SchemaRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schemaRegistry = new SchemaRegistry("schemaRegistry", SchemaRegistryArgs.builder()
 *             .groupProperties()
 *             .namespaceName("ali-ua-test-eh-system-1")
 *             .resourceGroupName("alitest")
 *             .schemaCompatibility("Forward")
 *             .schemaGroupName("testSchemaGroup1")
 *             .schemaType("Avro")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:SchemaRegistry testSchemaGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/schemagroups/{schemaGroupName}
 * ```
 * @property groupProperties dictionary object for SchemaGroup group properties
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property schemaCompatibility
 * @property schemaGroupName The Schema Group name
 * @property schemaType
 */
public data class SchemaRegistryArgs(
    public val groupProperties: Output<Map<String, String>>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaCompatibility: Output<Either<String, SchemaCompatibility>>? = null,
    public val schemaGroupName: Output<String>? = null,
    public val schemaType: Output<Either<String, SchemaType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.SchemaRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.SchemaRegistryArgs =
        com.pulumi.azurenative.eventhub.SchemaRegistryArgs.builder()
            .groupProperties(
                groupProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaCompatibility(
                schemaCompatibility?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .schemaGroupName(schemaGroupName?.applyValue({ args0 -> args0 }))
            .schemaType(
                schemaType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchemaRegistryArgs].
 */
@PulumiTagMarker
public class SchemaRegistryArgsBuilder internal constructor() {
    private var groupProperties: Output<Map<String, String>>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaCompatibility: Output<Either<String, SchemaCompatibility>>? = null

    private var schemaGroupName: Output<String>? = null

    private var schemaType: Output<Either<String, SchemaType>>? = null

    /**
     * @param value dictionary object for SchemaGroup group properties
     */
    @JvmName("ofnikltxheqfkdwc")
    public suspend fun groupProperties(`value`: Output<Map<String, String>>) {
        this.groupProperties = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("yawxgltwuncrvgjt")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("lybeeuopvbsbwocp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("paiisxelguphwqna")
    public suspend fun schemaCompatibility(`value`: Output<Either<String, SchemaCompatibility>>) {
        this.schemaCompatibility = value
    }

    /**
     * @param value The Schema Group name
     */
    @JvmName("ilaxetaoippcpyjp")
    public suspend fun schemaGroupName(`value`: Output<String>) {
        this.schemaGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("qqmowqkhfoebycdt")
    public suspend fun schemaType(`value`: Output<Either<String, SchemaType>>) {
        this.schemaType = value
    }

    /**
     * @param value dictionary object for SchemaGroup group properties
     */
    @JvmName("rducxyooqmgunrkg")
    public suspend fun groupProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupProperties = mapped
    }

    /**
     * @param values dictionary object for SchemaGroup group properties
     */
    @JvmName("kxyasrwfaphbpnpg")
    public fun groupProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupProperties = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("pcxsyislaexbxawr")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("snaawttexerpidnj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("twrtrijavqiyfnlw")
    public suspend fun schemaCompatibility(`value`: Either<String, SchemaCompatibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaCompatibility = mapped
    }

    /**
     * @param value
     */
    @JvmName("gmgcxmmtggoespdo")
    public fun schemaCompatibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaCompatibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaCompatibility = mapped
    }

    /**
     * @param value
     */
    @JvmName("owggtrdacfkivipw")
    public fun schemaCompatibility(`value`: SchemaCompatibility) {
        val toBeMapped = Either.ofRight<String, SchemaCompatibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaCompatibility = mapped
    }

    /**
     * @param value The Schema Group name
     */
    @JvmName("jgukgakdgsjjrikm")
    public suspend fun schemaGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("lubwyckecbyhxkxa")
    public suspend fun schemaType(`value`: Either<String, SchemaType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value
     */
    @JvmName("uobhegpjysipsgau")
    public fun schemaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqwpxkuuhvxngfck")
    public fun schemaType(`value`: SchemaType) {
        val toBeMapped = Either.ofRight<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    internal fun build(): SchemaRegistryArgs = SchemaRegistryArgs(
        groupProperties = groupProperties,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        schemaCompatibility = schemaCompatibility,
        schemaGroupName = schemaGroupName,
        schemaType = schemaType,
    )
}
