@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
 */
public enum class EncodingCaptureDescription(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription> {
    Avro(com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription.Avro),
    AvroDeflate(com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription.AvroDeflate),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.EncodingCaptureDescription):
            EncodingCaptureDescription =
            EncodingCaptureDescription.values().first { it.javaValue == javaType }
    }
}
