@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
 */
public enum class MetricId(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.MetricId,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.MetricId> {
    IncomingBytes(com.pulumi.azurenative.eventhub.enums.MetricId.IncomingBytes),
    OutgoingBytes(com.pulumi.azurenative.eventhub.enums.MetricId.OutgoingBytes),
    IncomingMessages(com.pulumi.azurenative.eventhub.enums.MetricId.IncomingMessages),
    OutgoingMessages(com.pulumi.azurenative.eventhub.enums.MetricId.OutgoingMessages),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.MetricId = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.MetricId): MetricId =
            MetricId.values().first { it.javaValue == javaType }
    }
}
