@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.KeySource
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties to configure Encryption
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 * @property requireInfrastructureEncryption Enable Infrastructure Encryption (Double Encryption)
 */
public data class EncryptionArgs(
    public val keySource: Output<KeySource>? = null,
    public val keyVaultProperties: Output<List<KeyVaultPropertiesArgs>>? = null,
    public val requireInfrastructureEncryption: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.EncryptionArgs =
        com.pulumi.azurenative.eventhub.inputs.EncryptionArgs.builder()
            .keySource(keySource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requireInfrastructureEncryption(
                requireInfrastructureEncryption?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keySource: Output<KeySource>? = null

    private var keyVaultProperties: Output<List<KeyVaultPropertiesArgs>>? = null

    private var requireInfrastructureEncryption: Output<Boolean>? = null

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("ersukvryfsucwiko")
    public suspend fun keySource(`value`: Output<KeySource>) {
        this.keySource = value
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("ghofvelvonhkrdhg")
    public suspend fun keyVaultProperties(`value`: Output<List<KeyVaultPropertiesArgs>>) {
        this.keyVaultProperties = value
    }

    @JvmName("cjwrryhsgmhkqmvi")
    public suspend fun keyVaultProperties(vararg values: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = Output.all(values.asList())
    }

    /**
     * @param values Properties of KeyVault
     */
    @JvmName("damygcnypiuvjohp")
    public suspend fun keyVaultProperties(values: List<Output<KeyVaultPropertiesArgs>>) {
        this.keyVaultProperties = Output.all(values)
    }

    /**
     * @param value Enable Infrastructure Encryption (Double Encryption)
     */
    @JvmName("yrmamxyqyjtmucto")
    public suspend fun requireInfrastructureEncryption(`value`: Output<Boolean>) {
        this.requireInfrastructureEncryption = value
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("vyjvdbeqovcbfovc")
    public suspend fun keySource(`value`: KeySource?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("brvtoxnmekakauct")
    public suspend fun keyVaultProperties(`value`: List<KeyVaultPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("vpuywpsvcsyqgkpk")
    public suspend
    fun keyVaultProperties(argument: List<suspend KeyVaultPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KeyVaultPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("krhiirkdwmviqded")
    public suspend fun keyVaultProperties(
        vararg
        argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KeyVaultPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("demxuheiwcwlcbih")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param values Properties of KeyVault
     */
    @JvmName("kchsgahkaiavbwfe")
    public suspend fun keyVaultProperties(vararg values: KeyVaultPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Enable Infrastructure Encryption (Double Encryption)
     */
    @JvmName("jasjepkuiugatcxs")
    public suspend fun requireInfrastructureEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInfrastructureEncryption = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
        requireInfrastructureEncryption = requireInfrastructureEncryption,
    )
}
