@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetEventHubAuthorizationRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property eventHubName The Event Hub name
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class GetEventHubAuthorizationRulePlainArgs(
    public val authorizationRuleName: String,
    public val eventHubName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetEventHubAuthorizationRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventhub.inputs.GetEventHubAuthorizationRulePlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetEventHubAuthorizationRulePlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .eventHubName(eventHubName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventHubAuthorizationRulePlainArgs].
 */
@PulumiTagMarker
public class GetEventHubAuthorizationRulePlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var eventHubName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("ivethhyhhbgqufrm")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("ihrkmvwgtuebdbmc")
    public suspend fun eventHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventHubName = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("nwlxctwhjrkjdpgm")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("ouekhilkvdpghjtq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEventHubAuthorizationRulePlainArgs =
        GetEventHubAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName ?: throw
                PulumiNullFieldException("authorizationRuleName"),
            eventHubName = eventHubName ?: throw PulumiNullFieldException("eventHubName"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
