@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetEventHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventHubName The Event Hub name
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class GetEventHubPlainArgs(
    public val eventHubName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetEventHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.GetEventHubPlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetEventHubPlainArgs.builder()
            .eventHubName(eventHubName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventHubPlainArgs].
 */
@PulumiTagMarker
public class GetEventHubPlainArgsBuilder internal constructor() {
    private var eventHubName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Event Hub name
     */
    @JvmName("spebsgqywnoiqolh")
    public suspend fun eventHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventHubName = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("tqeuemyojrkplnae")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("wwnwaywkawivaork")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEventHubPlainArgs = GetEventHubPlainArgs(
        eventHubName = eventHubName ?: throw PulumiNullFieldException("eventHubName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
