@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.IdentityArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties to configure Identity for Bring your Own Keys
 * @property type Type of managed service identity.
 * @property userAssignedIdentities Properties for User Assigned Identities
 */
public data class IdentityArgs(
    public val type: Output<ManagedServiceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.IdentityArgs =
        com.pulumi.azurenative.eventhub.inputs.IdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<ManagedServiceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("dpqarnxadwgpwuxb")
    public suspend fun type(`value`: Output<ManagedServiceIdentityType>) {
        this.type = value
    }

    /**
     * @param value Properties for User Assigned Identities
     */
    @JvmName("naswvttstptawneo")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("uddmrspwfhskxuht")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Properties for User Assigned Identities
     */
    @JvmName("rjrhxktgedaldswc")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("cquciriomrqvpjvp")
    public suspend fun type(`value`: ManagedServiceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Properties for User Assigned Identities
     */
    @JvmName("jbdwaliooneeuite")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Properties for User Assigned Identities
     */
    @JvmName("eerrobwkohvssjps")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
