@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.CleanupPolicyRetentionDescription
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties to configure retention settings for the  eventhub
 * @property cleanupPolicy Enumerates the possible values for cleanup policy
 * @property retentionTimeInHours Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is Long.MaxValue
 * @property tombstoneRetentionTimeInHours Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
 */
public data class RetentionDescriptionArgs(
    public val cleanupPolicy: Output<Either<String, CleanupPolicyRetentionDescription>>? = null,
    public val retentionTimeInHours: Output<Double>? = null,
    public val tombstoneRetentionTimeInHours: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs =
        com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs.builder()
            .cleanupPolicy(
                cleanupPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .retentionTimeInHours(retentionTimeInHours?.applyValue({ args0 -> args0 }))
            .tombstoneRetentionTimeInHours(
                tombstoneRetentionTimeInHours?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [RetentionDescriptionArgs].
 */
@PulumiTagMarker
public class RetentionDescriptionArgsBuilder internal constructor() {
    private var cleanupPolicy: Output<Either<String, CleanupPolicyRetentionDescription>>? = null

    private var retentionTimeInHours: Output<Double>? = null

    private var tombstoneRetentionTimeInHours: Output<Int>? = null

    /**
     * @param value Enumerates the possible values for cleanup policy
     */
    @JvmName("alaucbdxiwqqcvnw")
    public suspend
    fun cleanupPolicy(`value`: Output<Either<String, CleanupPolicyRetentionDescription>>) {
        this.cleanupPolicy = value
    }

    /**
     * @param value Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is Long.MaxValue
     */
    @JvmName("ohvowltrsrtcvieo")
    public suspend fun retentionTimeInHours(`value`: Output<Double>) {
        this.retentionTimeInHours = value
    }

    /**
     * @param value Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
     */
    @JvmName("ysvydtccujoiwunv")
    public suspend fun tombstoneRetentionTimeInHours(`value`: Output<Int>) {
        this.tombstoneRetentionTimeInHours = value
    }

    /**
     * @param value Enumerates the possible values for cleanup policy
     */
    @JvmName("olnsfnjjqyrkvmss")
    public suspend fun cleanupPolicy(`value`: Either<String, CleanupPolicyRetentionDescription>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanupPolicy = mapped
    }

    /**
     * @param value Enumerates the possible values for cleanup policy
     */
    @JvmName("kdcqsoovqxsxubdr")
    public fun cleanupPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CleanupPolicyRetentionDescription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPolicy = mapped
    }

    /**
     * @param value Enumerates the possible values for cleanup policy
     */
    @JvmName("uypwoagkrrebqdri")
    public fun cleanupPolicy(`value`: CleanupPolicyRetentionDescription) {
        val toBeMapped = Either.ofRight<String, CleanupPolicyRetentionDescription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPolicy = mapped
    }

    /**
     * @param value Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is Long.MaxValue
     */
    @JvmName("waunonrtytdjcnac")
    public suspend fun retentionTimeInHours(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimeInHours = mapped
    }

    /**
     * @param value Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
     */
    @JvmName("tkmpomsvoxnbrcnv")
    public suspend fun tombstoneRetentionTimeInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tombstoneRetentionTimeInHours = mapped
    }

    internal fun build(): RetentionDescriptionArgs = RetentionDescriptionArgs(
        cleanupPolicy = cleanupPolicy,
        retentionTimeInHours = retentionTimeInHours,
        tombstoneRetentionTimeInHours = tombstoneRetentionTimeInHours,
    )
}
