@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single item in List or Get Consumer group operation
 * @property createdAt Exact time the message was created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The exact time the message was updated.
 * @property userMetadata User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
 */
public data class GetConsumerGroupResult(
    public val createdAt: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
    public val userMetadata: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetConsumerGroupResult):
            GetConsumerGroupResult = GetConsumerGroupResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
            userMetadata = javaType.userMetadata().map({ args0 -> args0 }).orElse(null),
        )
    }
}
