@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the throttling policy
 * @property metricId Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
 * @property name The Name of this policy
 * @property rateLimitThreshold The Threshold limit above which the application group will be throttled.Rate limit is always per second.
 * @property type Application Group Policy types
 * Expected value is 'ThrottlingPolicy'.
 */
public data class ThrottlingPolicyResponse(
    public val metricId: String,
    public val name: String,
    public val rateLimitThreshold: Double,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.ThrottlingPolicyResponse):
            ThrottlingPolicyResponse = ThrottlingPolicyResponse(
            metricId = javaType.metricId(),
            name = javaType.name(),
            rateLimitThreshold = javaType.rateLimitThreshold(),
            type = javaType.type(),
        )
    }
}
