@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin

import com.pulumi.azurenative.extendedlocation.kotlin.outputs.CustomLocationPropertiesResponseAuthentication
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.CustomLocationPropertiesResponseAuthentication.Companion.toKotlin as customLocationPropertiesResponseAuthenticationToKotlin
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomLocation].
 */
@PulumiTagMarker
public class CustomLocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomLocationArgs = CustomLocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomLocationArgsBuilder.() -> Unit) {
        val builder = CustomLocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomLocation {
        val builtJavaResource =
            com.pulumi.azurenative.extendedlocation.CustomLocation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomLocation(builtJavaResource)
    }
}

/**
 * Custom Locations definition.
 * Azure REST API version: 2021-08-15. Prior API version in Azure Native 1.x: 2021-03-15-preview.
 * Other available API versions: 2021-08-31-preview.
 * ## Example Usage
 * ### Create/Update Custom Location
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customLocation = new AzureNative.ExtendedLocation.CustomLocation("customLocation", new()
 *     {
 *         Authentication = new AzureNative.ExtendedLocation.Inputs.CustomLocationPropertiesAuthenticationArgs
 *         {
 *             Type = "KubeConfig",
 *             Value = "<base64 KubeConfig>",
 *         },
 *         ClusterExtensionIds = new[]
 *         {
 *             "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension",
 *         },
 *         DisplayName = "customLocationLocation01",
 *         HostResourceId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01",
 *         Identity = new AzureNative.ExtendedLocation.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.ExtendedLocation.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Namespace = "namespace01",
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "customLocation01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/extendedlocation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := extendedlocation.NewCustomLocation(ctx, "customLocation", &extendedlocation.CustomLocationArgs{
 * 			Authentication: &extendedlocation.CustomLocationPropertiesAuthenticationArgs{
 * 				Type:  pulumi.String("KubeConfig"),
 * 				Value: pulumi.String("<base64 KubeConfig>"),
 * 			},
 * 			ClusterExtensionIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension"),
 * 			},
 * 			DisplayName:    pulumi.String("customLocationLocation01"),
 * 			HostResourceId: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01"),
 * 			Identity: &extendedlocation.IdentityArgs{
 * 				Type: pulumi.String(extendedlocation.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			Namespace:         pulumi.String("namespace01"),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("customLocation01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.extendedlocation.CustomLocation;
 * import com.pulumi.azurenative.extendedlocation.CustomLocationArgs;
 * import com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs;
 * import com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customLocation = new CustomLocation("customLocation", CustomLocationArgs.builder()
 *             .authentication(CustomLocationPropertiesAuthenticationArgs.builder()
 *                 .type("KubeConfig")
 *                 .value("<base64 KubeConfig>")
 *                 .build())
 *             .clusterExtensionIds("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension")
 *             .displayName("customLocationLocation01")
 *             .hostResourceId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .namespace("namespace01")
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("customLocation01")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:extendedlocation:CustomLocation customLocation01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ExtendedLocation/customLocations/{resourceName}
 * ```
 */
public class CustomLocation internal constructor(
    override val javaResource: com.pulumi.azurenative.extendedlocation.CustomLocation,
) : KotlinCustomResource(javaResource, CustomLocationMapper) {
    /**
     * This is optional input that contains the authentication that should be used to generate the namespace.
     */
    public val authentication: Output<CustomLocationPropertiesResponseAuthentication>?
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customLocationPropertiesResponseAuthenticationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains the reference to the add-on that contains charts to deploy CRDs and operators.
     */
    public val clusterExtensionIds: Output<List<String>>?
        get() = javaResource.clusterExtensionIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Display name for the Custom Locations location.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connected Cluster or AKS Cluster. The Custom Locations RP will perform a checkAccess API for listAdminCredentials permissions.
     */
    public val hostResourceId: Output<String>?
        get() = javaResource.hostResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of host the Custom Locations is referencing (Kubernetes, etc...).
     */
    public val hostType: Output<String>?
        get() = javaResource.hostType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Kubernetes namespace that will be created on the specified cluster.
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning State for the Custom Location.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomLocationMapper : ResourceMapper<CustomLocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.extendedlocation.CustomLocation::class == javaResource::class

    override fun map(javaResource: Resource): CustomLocation = CustomLocation(
        javaResource as
            com.pulumi.azurenative.extendedlocation.CustomLocation,
    )
}

/**
 * @see [CustomLocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomLocation].
 */
public suspend fun customLocation(
    name: String,
    block: suspend CustomLocationResourceBuilder.() -> Unit,
): CustomLocation {
    val builder = CustomLocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomLocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customLocation(name: String): CustomLocation {
    val builder = CustomLocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
