@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin

import com.pulumi.azurenative.extendedlocation.kotlin.outputs.ResourceSyncRulePropertiesResponseSelector
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.ResourceSyncRulePropertiesResponseSelector.Companion.toKotlin as resourceSyncRulePropertiesResponseSelectorToKotlin
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ResourceSyncRule].
 */
@PulumiTagMarker
public class ResourceSyncRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceSyncRuleArgs = ResourceSyncRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceSyncRuleArgsBuilder.() -> Unit) {
        val builder = ResourceSyncRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceSyncRule {
        val builtJavaResource =
            com.pulumi.azurenative.extendedlocation.ResourceSyncRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceSyncRule(builtJavaResource)
    }
}

/**
 * Resource Sync Rules definition.
 * Azure REST API version: 2021-08-31-preview. Prior API version in Azure Native 1.x: 2021-08-31-preview.
 * ## Example Usage
 * ### Create/Update Resource Sync Rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceSyncRule = new AzureNative.ExtendedLocation.ResourceSyncRule("resourceSyncRule", new()
 *     {
 *         ChildResourceName = "resourceSyncRule01",
 *         Location = "West US",
 *         Priority = 999,
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "customLocation01",
 *         Selector = new AzureNative.ExtendedLocation.Inputs.ResourceSyncRulePropertiesSelectorArgs
 *         {
 *             MatchLabels =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         TargetResourceGroup = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/extendedlocation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := extendedlocation.NewResourceSyncRule(ctx, "resourceSyncRule", &extendedlocation.ResourceSyncRuleArgs{
 * 			ChildResourceName: pulumi.String("resourceSyncRule01"),
 * 			Location:          pulumi.String("West US"),
 * 			Priority:          pulumi.Int(999),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("customLocation01"),
 * 			Selector: &extendedlocation.ResourceSyncRulePropertiesSelectorArgs{
 * 				MatchLabels: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			TargetResourceGroup: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.extendedlocation.ResourceSyncRule;
 * import com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs;
 * import com.pulumi.azurenative.extendedlocation.inputs.ResourceSyncRulePropertiesSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceSyncRule = new ResourceSyncRule("resourceSyncRule", ResourceSyncRuleArgs.builder()
 *             .childResourceName("resourceSyncRule01")
 *             .location("West US")
 *             .priority(999)
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("customLocation01")
 *             .selector(ResourceSyncRulePropertiesSelectorArgs.builder()
 *                 .matchLabels(Map.of("key1", "value1"))
 *                 .build())
 *             .targetResourceGroup("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:extendedlocation:ResourceSyncRule resourceSyncRule01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ExtendedLocation/customLocations/{resourceName}/resourceSyncRules/{childResourceName}
 * ```
 */
public class ResourceSyncRule internal constructor(
    override val javaResource: com.pulumi.azurenative.extendedlocation.ResourceSyncRule,
) : KotlinCustomResource(javaResource, ResourceSyncRuleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Priority represents a priority of the Resource Sync Rule
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning State for the Resource Sync Rule.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
     */
    public val selector: Output<ResourceSyncRulePropertiesResponseSelector>?
        get() = javaResource.selector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSyncRulePropertiesResponseSelectorToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * For an unmapped custom resource, its labels will be used to find matching resource sync rules. If this resource sync rule is one of the matching rules with highest priority, then the unmapped custom resource will be projected to the target resource group associated with this resource sync rule. The user creating this resource sync rule should have write permissions on the target resource group and this write permission will be validated when creating the resource sync rule.
     */
    public val targetResourceGroup: Output<String>?
        get() = javaResource.targetResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceSyncRuleMapper : ResourceMapper<ResourceSyncRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.extendedlocation.ResourceSyncRule::class == javaResource::class

    override fun map(javaResource: Resource): ResourceSyncRule = ResourceSyncRule(
        javaResource as
            com.pulumi.azurenative.extendedlocation.ResourceSyncRule,
    )
}

/**
 * @see [ResourceSyncRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceSyncRule].
 */
public suspend fun resourceSyncRule(
    name: String,
    block: suspend ResourceSyncRuleResourceBuilder.() -> Unit,
): ResourceSyncRule {
    val builder = ResourceSyncRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceSyncRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceSyncRule(name: String): ResourceSyncRule {
    val builder = ResourceSyncRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
