@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin

import com.pulumi.azurenative.features.FeaturesFunctions.getSubscriptionFeatureRegistrationPlain
import com.pulumi.azurenative.features.kotlin.inputs.GetSubscriptionFeatureRegistrationPlainArgs
import com.pulumi.azurenative.features.kotlin.inputs.GetSubscriptionFeatureRegistrationPlainArgsBuilder
import com.pulumi.azurenative.features.kotlin.outputs.GetSubscriptionFeatureRegistrationResult
import com.pulumi.azurenative.features.kotlin.outputs.GetSubscriptionFeatureRegistrationResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object FeaturesFunctions {
    /**
     * Returns a feature registration
     * Azure REST API version: 2021-07-01.
     * @param argument null
     * @return Subscription feature registration details
     */
    public suspend
    fun getSubscriptionFeatureRegistration(argument: GetSubscriptionFeatureRegistrationPlainArgs):
        GetSubscriptionFeatureRegistrationResult =
        toKotlin(getSubscriptionFeatureRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getSubscriptionFeatureRegistration].
     * @param featureName The feature name.
     * @param providerNamespace The provider namespace.
     * @return Subscription feature registration details
     */
    public suspend fun getSubscriptionFeatureRegistration(
        featureName: String,
        providerNamespace: String,
    ): GetSubscriptionFeatureRegistrationResult {
        val argument = GetSubscriptionFeatureRegistrationPlainArgs(
            featureName = featureName,
            providerNamespace = providerNamespace,
        )
        return toKotlin(getSubscriptionFeatureRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscriptionFeatureRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;features&#46;kotlin&#46;inputs&#46;GetSubscriptionFeatureRegistrationPlainArgs].
     * @return Subscription feature registration details
     */
    public suspend
    fun getSubscriptionFeatureRegistration(argument: suspend GetSubscriptionFeatureRegistrationPlainArgsBuilder.() -> Unit):
        GetSubscriptionFeatureRegistrationResult {
        val builder = GetSubscriptionFeatureRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getSubscriptionFeatureRegistrationPlain(builtArgument.toJava()).await())
    }
}
