@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property identityType Values can be SystemAssigned or UserAssigned
 * @property userAssignedIdentityResourceId user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
 */
public data class CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity(
    public val identityType: String? = null,
    public val userAssignedIdentityResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.fluidrelay.outputs.CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity):
            CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity =
            CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity(
                identityType = javaType.identityType().map({ args0 -> args0 }).orElse(null),
                userAssignedIdentityResourceId = javaType.userAssignedIdentityResourceId().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
