@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin

import com.pulumi.azurenative.graphservices.AccountArgs.builder
import com.pulumi.azurenative.graphservices.kotlin.inputs.AccountResourcePropertiesArgs
import com.pulumi.azurenative.graphservices.kotlin.inputs.AccountResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Account details
 * Azure REST API version: 2023-04-13. Prior API version in Azure Native 1.x: 2022-09-22-preview.
 * ## Example Usage
 * ### Create Account resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.GraphServices.Account("account", new()
 *     {
 *         Properties = new AzureNative.GraphServices.Inputs.AccountResourcePropertiesArgs
 *         {
 *             AppId = "11111111-aaaa-1111-bbbb-111111111111",
 *         },
 *         ResourceGroupName = "testResourceGroupGRAM",
 *         ResourceName = "11111111-aaaa-1111-bbbb-1111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/graphservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := graphservices.NewAccount(ctx, "account", &graphservices.AccountArgs{
 * 			Properties: &graphservices.AccountResourcePropertiesArgs{
 * 				AppId: pulumi.String("11111111-aaaa-1111-bbbb-111111111111"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroupGRAM"),
 * 			ResourceName:      pulumi.String("11111111-aaaa-1111-bbbb-1111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.graphservices.Account;
 * import com.pulumi.azurenative.graphservices.AccountArgs;
 * import com.pulumi.azurenative.graphservices.inputs.AccountResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .properties(AccountResourcePropertiesArgs.builder()
 *                 .appId("11111111-aaaa-1111-bbbb-111111111111")
 *                 .build())
 *             .resourceGroupName("testResourceGroupGRAM")
 *             .resourceName("11111111-aaaa-1111-bbbb-1111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:graphservices:Account 11111111-aaaa-1111-bbbb-111111111111 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.GraphServices/accounts/{resourceName}
 * ```
 * @property location Location of the resource.
 * @property properties Property bag from billing account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 * @property tags resource tags.
 */
public data class AccountArgs(
    public val location: Output<String>? = null,
    public val properties: Output<AccountResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.graphservices.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.graphservices.AccountArgs =
        com.pulumi.azurenative.graphservices.AccountArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<AccountResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Location of the resource.
     */
    @JvmName("lnlqreltltmkqewl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Property bag from billing account
     */
    @JvmName("buaotoecnoyfovqg")
    public suspend fun properties(`value`: Output<AccountResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iuglashimeyjwtex")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ieimcacjrvrycjds")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value resource tags.
     */
    @JvmName("ijjieehhxlpojywc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("bgjjekirojqeggnt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Property bag from billing account
     */
    @JvmName("vvltwmqrmogpdqoc")
    public suspend fun properties(`value`: AccountResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Property bag from billing account
     */
    @JvmName("bpyognimymuwgwvf")
    public suspend fun properties(argument: suspend AccountResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rlkldviqvnoynvuw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("rhpxoiqtwklfqspj")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value resource tags.
     */
    @JvmName("aekqqsqjcyfvihcv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values resource tags.
     */
    @JvmName("wlufdyoldipgyfqa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
