@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin

import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GuestConfigurationAssignmentPropertiesResponse
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GuestConfigurationAssignmentPropertiesResponse.Companion.toKotlin as guestConfigurationAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GuestConfigurationHCRPAssignment].
 */
@PulumiTagMarker
public class GuestConfigurationHCRPAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GuestConfigurationHCRPAssignmentArgs = GuestConfigurationHCRPAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GuestConfigurationHCRPAssignmentArgsBuilder.() -> Unit) {
        val builder = GuestConfigurationHCRPAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GuestConfigurationHCRPAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GuestConfigurationHCRPAssignment(builtJavaResource)
    }
}

/**
 * Guest configuration assignment is an association between a machine and guest configuration.
 * Azure REST API version: 2022-01-25. Prior API version in Azure Native 1.x: 2020-06-25.
 * ## Example Usage
 * ### Create or update guest configuration assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestConfigurationHCRPAssignment = new AzureNative.GuestConfiguration.GuestConfigurationHCRPAssignment("guestConfigurationHCRPAssignment", new()
 *     {
 *         GuestConfigurationAssignmentName = "NotInstalledApplicationForWindows",
 *         Location = "westcentralus",
 *         MachineName = "myMachineName",
 *         Name = "NotInstalledApplicationForWindows",
 *         Properties = new AzureNative.GuestConfiguration.Inputs.GuestConfigurationAssignmentPropertiesArgs
 *         {
 *             Context = "Azure policy",
 *             GuestConfiguration = new AzureNative.GuestConfiguration.Inputs.GuestConfigurationNavigationArgs
 *             {
 *                 AssignmentType = AzureNative.GuestConfiguration.AssignmentType.ApplyAndAutoCorrect,
 *                 ConfigurationParameter = new[]
 *                 {
 *                     new AzureNative.GuestConfiguration.Inputs.ConfigurationParameterArgs
 *                     {
 *                         Name = "[InstalledApplication]NotInstalledApplicationResource1;Name",
 *                         Value = "NotePad,sql",
 *                     },
 *                 },
 *                 ContentHash = "123contenthash",
 *                 ContentUri = "https://thisisfake/pacakge",
 *                 Name = "NotInstalledApplicationForWindows",
 *                 Version = "1.0.0.3",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/guestconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := guestconfiguration.NewGuestConfigurationHCRPAssignment(ctx, "guestConfigurationHCRPAssignment", &guestconfiguration.GuestConfigurationHCRPAssignmentArgs{
 * 			GuestConfigurationAssignmentName: pulumi.String("NotInstalledApplicationForWindows"),
 * 			Location:                         pulumi.String("westcentralus"),
 * 			MachineName:                      pulumi.String("myMachineName"),
 * 			Name:                             pulumi.String("NotInstalledApplicationForWindows"),
 * 			Properties: &guestconfiguration.GuestConfigurationAssignmentPropertiesArgs{
 * 				Context: pulumi.String("Azure policy"),
 * 				GuestConfiguration: &guestconfiguration.GuestConfigurationNavigationArgs{
 * 					AssignmentType: pulumi.String(guestconfiguration.AssignmentTypeApplyAndAutoCorrect),
 * 					ConfigurationParameter: guestconfiguration.ConfigurationParameterArray{
 * 						&guestconfiguration.ConfigurationParameterArgs{
 * 							Name:  pulumi.String("[InstalledApplication]NotInstalledApplicationResource1;Name"),
 * 							Value: pulumi.String("NotePad,sql"),
 * 						},
 * 					},
 * 					ContentHash: pulumi.String("123contenthash"),
 * 					ContentUri:  pulumi.String("https://thisisfake/pacakge"),
 * 					Name:        pulumi.String("NotInstalledApplicationForWindows"),
 * 					Version:     pulumi.String("1.0.0.3"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment;
 * import com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs;
 * import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestConfigurationHCRPAssignment = new GuestConfigurationHCRPAssignment("guestConfigurationHCRPAssignment", GuestConfigurationHCRPAssignmentArgs.builder()
 *             .guestConfigurationAssignmentName("NotInstalledApplicationForWindows")
 *             .location("westcentralus")
 *             .machineName("myMachineName")
 *             .name("NotInstalledApplicationForWindows")
 *             .properties(GuestConfigurationAssignmentPropertiesArgs.builder()
 *                 .context("Azure policy")
 *                 .guestConfiguration(GuestConfigurationNavigationArgs.builder()
 *                     .assignmentType("ApplyAndAutoCorrect")
 *                     .configurationParameter(ConfigurationParameterArgs.builder()
 *                         .name("[InstalledApplication]NotInstalledApplicationResource1;Name")
 *                         .value("NotePad,sql")
 *                         .build())
 *                     .contentHash("123contenthash")
 *                     .contentUri("https://thisisfake/pacakge")
 *                     .name("NotInstalledApplicationForWindows")
 *                     .version("1.0.0.3")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:guestconfiguration:GuestConfigurationHCRPAssignment NotInstalledApplicationForWindows /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}
 * ```
 */
public class GuestConfigurationHCRPAssignment internal constructor(
    override val javaResource:
    com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment,
) : KotlinCustomResource(javaResource, GuestConfigurationHCRPAssignmentMapper) {
    /**
     * Region where the VM is located.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the guest configuration assignment.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Properties of the Guest configuration assignment.
     */
    public val properties: Output<GuestConfigurationAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                guestConfigurationAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GuestConfigurationHCRPAssignmentMapper :
    ResourceMapper<GuestConfigurationHCRPAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment::class == javaResource::class

    override fun map(javaResource: Resource): GuestConfigurationHCRPAssignment =
        GuestConfigurationHCRPAssignment(
            javaResource as
                com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment,
        )
}

/**
 * @see [GuestConfigurationHCRPAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GuestConfigurationHCRPAssignment].
 */
public suspend fun guestConfigurationHCRPAssignment(
    name: String,
    block: suspend GuestConfigurationHCRPAssignmentResourceBuilder.() -> Unit,
):
    GuestConfigurationHCRPAssignment {
    val builder = GuestConfigurationHCRPAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GuestConfigurationHCRPAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun guestConfigurationHCRPAssignment(name: String): GuestConfigurationHCRPAssignment {
    val builder = GuestConfigurationHCRPAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
