@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.ConfigurationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a configuration parameter.
 * @property name Name of the configuration parameter.
 * @property value Value of the configuration parameter.
 */
public data class ConfigurationParameterArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.ConfigurationParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.guestconfiguration.inputs.ConfigurationParameterArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.ConfigurationParameterArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationParameterArgs].
 */
@PulumiTagMarker
public class ConfigurationParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the configuration parameter.
     */
    @JvmName("wsojmryjjmoslulu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of the configuration parameter.
     */
    @JvmName("guxucuhyoqpxfmnr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the configuration parameter.
     */
    @JvmName("qkdvtwvranovcwni")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of the configuration parameter.
     */
    @JvmName("tlnebgjkohmxcdsp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConfigurationParameterArgs = ConfigurationParameterArgs(
        name = name,
        `value` = `value`,
    )
}
