@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Guest configuration assignment properties.
 * @property context The source which initiated the guest configuration assignment. Ex: Azure Policy
 * @property guestConfiguration The guest configuration to assign.
 */
public data class GuestConfigurationAssignmentPropertiesArgs(
    public val context: Output<String>? = null,
    public val guestConfiguration: Output<GuestConfigurationNavigationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs.builder()
            .context(context?.applyValue({ args0 -> args0 }))
            .guestConfiguration(
                guestConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GuestConfigurationAssignmentPropertiesArgs].
 */
@PulumiTagMarker
public class GuestConfigurationAssignmentPropertiesArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var guestConfiguration: Output<GuestConfigurationNavigationArgs>? = null

    /**
     * @param value The source which initiated the guest configuration assignment. Ex: Azure Policy
     */
    @JvmName("imtijvwqcvxnxiaw")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value The guest configuration to assign.
     */
    @JvmName("cjlykeiosvssqtkn")
    public suspend fun guestConfiguration(`value`: Output<GuestConfigurationNavigationArgs>) {
        this.guestConfiguration = value
    }

    /**
     * @param value The source which initiated the guest configuration assignment. Ex: Azure Policy
     */
    @JvmName("ulqqafuxpjnpygjm")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value The guest configuration to assign.
     */
    @JvmName("ucrbjgpukpxalepq")
    public suspend fun guestConfiguration(`value`: GuestConfigurationNavigationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestConfiguration = mapped
    }

    /**
     * @param argument The guest configuration to assign.
     */
    @JvmName("mxxrcofgqknbloni")
    public suspend
    fun guestConfiguration(argument: suspend GuestConfigurationNavigationArgsBuilder.() -> Unit) {
        val toBeMapped = GuestConfigurationNavigationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guestConfiguration = mapped
    }

    internal fun build(): GuestConfigurationAssignmentPropertiesArgs =
        GuestConfigurationAssignmentPropertiesArgs(
            context = context,
            guestConfiguration = guestConfiguration,
        )
}
