@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs.builder
import com.pulumi.azurenative.guestconfiguration.kotlin.enums.AssignmentType
import com.pulumi.azurenative.guestconfiguration.kotlin.enums.Kind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact is a zip file containing DSC configuration (as MOF) and dependent resources and other dependencies like modules.
 * @property assignmentType Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
 * @property configurationParameter The configuration parameters for the guest configuration.
 * @property configurationProtectedParameter The protected configuration parameters for the guest configuration.
 * @property contentHash Combined hash of the guest configuration package and configuration parameters.
 * @property contentUri Uri of the storage where guest configuration package is uploaded.
 * @property kind Kind of the guest configuration. For example:DSC
 * @property name Name of the guest configuration.
 * @property version Version of the guest configuration.
 */
public data class GuestConfigurationNavigationArgs(
    public val assignmentType: Output<Either<String, AssignmentType>>? = null,
    public val configurationParameter: Output<List<ConfigurationParameterArgs>>? = null,
    public val configurationProtectedParameter: Output<List<ConfigurationParameterArgs>>? = null,
    public val contentHash: Output<String>? = null,
    public val contentUri: Output<String>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs> {
    override fun toJava():
        com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs.builder()
            .assignmentType(
                assignmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurationParameter(
                configurationParameter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurationProtectedParameter(
                configurationProtectedParameter?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .contentHash(contentHash?.applyValue({ args0 -> args0 }))
            .contentUri(contentUri?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestConfigurationNavigationArgs].
 */
@PulumiTagMarker
public class GuestConfigurationNavigationArgsBuilder internal constructor() {
    private var assignmentType: Output<Either<String, AssignmentType>>? = null

    private var configurationParameter: Output<List<ConfigurationParameterArgs>>? = null

    private var configurationProtectedParameter: Output<List<ConfigurationParameterArgs>>? = null

    private var contentHash: Output<String>? = null

    private var contentUri: Output<String>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
     */
    @JvmName("nrsxdxcjuikpxety")
    public suspend fun assignmentType(`value`: Output<Either<String, AssignmentType>>) {
        this.assignmentType = value
    }

    /**
     * @param value The configuration parameters for the guest configuration.
     */
    @JvmName("alxwelqpyyngjrvg")
    public suspend fun configurationParameter(`value`: Output<List<ConfigurationParameterArgs>>) {
        this.configurationParameter = value
    }

    @JvmName("sbsxmxlbgamumrua")
    public suspend fun configurationParameter(vararg values: Output<ConfigurationParameterArgs>) {
        this.configurationParameter = Output.all(values.asList())
    }

    /**
     * @param values The configuration parameters for the guest configuration.
     */
    @JvmName("ookroriqbmrkeyus")
    public suspend fun configurationParameter(values: List<Output<ConfigurationParameterArgs>>) {
        this.configurationParameter = Output.all(values)
    }

    /**
     * @param value The protected configuration parameters for the guest configuration.
     */
    @JvmName("ecmehbgkpyrkhwjr")
    public suspend
    fun configurationProtectedParameter(`value`: Output<List<ConfigurationParameterArgs>>) {
        this.configurationProtectedParameter = value
    }

    @JvmName("qxoyshsffmqeaygh")
    public suspend fun configurationProtectedParameter(
        vararg
        values: Output<ConfigurationParameterArgs>,
    ) {
        this.configurationProtectedParameter = Output.all(values.asList())
    }

    /**
     * @param values The protected configuration parameters for the guest configuration.
     */
    @JvmName("fqrsjampdqqpfcvt")
    public suspend
    fun configurationProtectedParameter(values: List<Output<ConfigurationParameterArgs>>) {
        this.configurationProtectedParameter = Output.all(values)
    }

    /**
     * @param value Combined hash of the guest configuration package and configuration parameters.
     */
    @JvmName("fatvvoiyjsisuxfe")
    public suspend fun contentHash(`value`: Output<String>) {
        this.contentHash = value
    }

    /**
     * @param value Uri of the storage where guest configuration package is uploaded.
     */
    @JvmName("xvhpkbeqdvaqsuwr")
    public suspend fun contentUri(`value`: Output<String>) {
        this.contentUri = value
    }

    /**
     * @param value Kind of the guest configuration. For example:DSC
     */
    @JvmName("lvlcddamdklbjtfa")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Name of the guest configuration.
     */
    @JvmName("xklotibmkhypjxbr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Version of the guest configuration.
     */
    @JvmName("cdcpivbeeelwqmpq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
     */
    @JvmName("hvculepvysprvifp")
    public suspend fun assignmentType(`value`: Either<String, AssignmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentType = mapped
    }

    /**
     * @param value Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
     */
    @JvmName("yhqmqaectborgtva")
    public fun assignmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignmentType = mapped
    }

    /**
     * @param value Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
     */
    @JvmName("cyooewhyhimyvkch")
    public fun assignmentType(`value`: AssignmentType) {
        val toBeMapped = Either.ofRight<String, AssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignmentType = mapped
    }

    /**
     * @param value The configuration parameters for the guest configuration.
     */
    @JvmName("wuybgdwfbrrtefqj")
    public suspend fun configurationParameter(`value`: List<ConfigurationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationParameter = mapped
    }

    /**
     * @param argument The configuration parameters for the guest configuration.
     */
    @JvmName("stfgniunmuywxypl")
    public suspend
    fun configurationParameter(argument: List<suspend ConfigurationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationParameter = mapped
    }

    /**
     * @param argument The configuration parameters for the guest configuration.
     */
    @JvmName("mitctjcyawuhiuqf")
    public suspend fun configurationParameter(
        vararg
        argument: suspend ConfigurationParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationParameter = mapped
    }

    /**
     * @param argument The configuration parameters for the guest configuration.
     */
    @JvmName("atomhnumncrbbumy")
    public suspend
    fun configurationParameter(argument: suspend ConfigurationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConfigurationParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configurationParameter = mapped
    }

    /**
     * @param values The configuration parameters for the guest configuration.
     */
    @JvmName("irvusasjrfxxoxbc")
    public suspend fun configurationParameter(vararg values: ConfigurationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationParameter = mapped
    }

    /**
     * @param value The protected configuration parameters for the guest configuration.
     */
    @JvmName("hxactkcjabxmrlcv")
    public suspend fun configurationProtectedParameter(`value`: List<ConfigurationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProtectedParameter = mapped
    }

    /**
     * @param argument The protected configuration parameters for the guest configuration.
     */
    @JvmName("vysdxijaefrbhfij")
    public suspend
    fun configurationProtectedParameter(argument: List<suspend ConfigurationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProtectedParameter = mapped
    }

    /**
     * @param argument The protected configuration parameters for the guest configuration.
     */
    @JvmName("fxuqcuwoijfrmamp")
    public suspend fun configurationProtectedParameter(
        vararg
        argument: suspend ConfigurationParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProtectedParameter = mapped
    }

    /**
     * @param argument The protected configuration parameters for the guest configuration.
     */
    @JvmName("favfdevkkjgmglfl")
    public suspend
    fun configurationProtectedParameter(argument: suspend ConfigurationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConfigurationParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configurationProtectedParameter = mapped
    }

    /**
     * @param values The protected configuration parameters for the guest configuration.
     */
    @JvmName("ixnyqmbhohwhdiwb")
    public suspend fun configurationProtectedParameter(vararg values: ConfigurationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProtectedParameter = mapped
    }

    /**
     * @param value Combined hash of the guest configuration package and configuration parameters.
     */
    @JvmName("vwehvwlycmquahiy")
    public suspend fun contentHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHash = mapped
    }

    /**
     * @param value Uri of the storage where guest configuration package is uploaded.
     */
    @JvmName("crpewjbecvcvcigl")
    public suspend fun contentUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentUri = mapped
    }

    /**
     * @param value Kind of the guest configuration. For example:DSC
     */
    @JvmName("skqqsejecawesmlf")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of the guest configuration. For example:DSC
     */
    @JvmName("sapystvwghcldmmf")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of the guest configuration. For example:DSC
     */
    @JvmName("xsgevootddnlrpdc")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the guest configuration.
     */
    @JvmName("inqvutsewlyvdlwc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Version of the guest configuration.
     */
    @JvmName("xddjpxofydwjwyex")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GuestConfigurationNavigationArgs = GuestConfigurationNavigationArgs(
        assignmentType = assignmentType,
        configurationParameter = configurationParameter,
        configurationProtectedParameter = configurationProtectedParameter,
        contentHash = contentHash,
        contentUri = contentUri,
        kind = kind,
        name = name,
        version = version,
    )
}
