@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reason and code for the compliance of the guest configuration assignment resource.
 * @property code Code for the compliance of the guest configuration assignment resource.
 * @property phrase Reason for the compliance of the guest configuration assignment resource.
 */
public data class AssignmentReportResourceComplianceReasonResponse(
    public val code: String,
    public val phrase: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.AssignmentReportResourceComplianceReasonResponse):
            AssignmentReportResourceComplianceReasonResponse =
            AssignmentReportResourceComplianceReasonResponse(
                code = javaType.code(),
                phrase = javaType.phrase(),
            )
    }
}
