@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the configuration.
 * @property name Name of the configuration.
 * @property version Version of the configuration.
 */
public data class ConfigurationInfoResponse(
    public val name: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.ConfigurationInfoResponse):
            ConfigurationInfoResponse = ConfigurationInfoResponse(
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
