@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about VMSS VM
 * @property complianceStatus A value indicating compliance status of the machine for the assigned guest configuration.
 * @property lastComplianceChecked Date and time when last compliance status was checked.
 * @property latestReportId Id of the latest report for the guest configuration assignment.
 * @property vmId UUID of the VM.
 * @property vmResourceId Azure resource Id of the VM.
 */
public data class VMSSVMInfoResponse(
    public val complianceStatus: String,
    public val lastComplianceChecked: String,
    public val latestReportId: String,
    public val vmId: String,
    public val vmResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.VMSSVMInfoResponse):
            VMSSVMInfoResponse = VMSSVMInfoResponse(
            complianceStatus = javaType.complianceStatus(),
            lastComplianceChecked = javaType.lastComplianceChecked(),
            latestReportId = javaType.latestReportId(),
            vmId = javaType.vmId(),
            vmResourceId = javaType.vmResourceId(),
        )
    }
}
