@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudHsmClusterPrivateEndpointConnection].
 */
@PulumiTagMarker
public class CloudHsmClusterPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudHsmClusterPrivateEndpointConnectionArgs =
        CloudHsmClusterPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend CloudHsmClusterPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = CloudHsmClusterPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudHsmClusterPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudHsmClusterPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * The private endpoint connection resource.
 * Azure REST API version: 2022-08-31-preview.
 * Other available API versions: 2023-12-10-preview.
 * ## Example Usage
 * ### CloudHsmClusterPrivateEndpointConnection_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudHsmClusterPrivateEndpointConnection = new AzureNative.HardwareSecurityModules.CloudHsmClusterPrivateEndpointConnection("cloudHsmClusterPrivateEndpointConnection", new()
 *     {
 *         CloudHsmClusterName = "chsm1",
 *         PeConnectionName = "sample-pec",
 *         PrivateLinkServiceConnectionState = new AzureNative.HardwareSecurityModules.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "My name is Joe and I'm approving this.",
 *             Status = AzureNative.HardwareSecurityModules.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "rgcloudhsm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewCloudHsmClusterPrivateEndpointConnection(ctx, "cloudHsmClusterPrivateEndpointConnection", &hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs{
 * 			CloudHsmClusterName: pulumi.String("chsm1"),
 * 			PeConnectionName:    pulumi.String("sample-pec"),
 * 			PrivateLinkServiceConnectionState: &hardwaresecuritymodules.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("My name is Joe and I'm approving this."),
 * 				Status:      pulumi.String(hardwaresecuritymodules.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgcloudhsm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudHsmClusterPrivateEndpointConnection = new CloudHsmClusterPrivateEndpointConnection("cloudHsmClusterPrivateEndpointConnection", CloudHsmClusterPrivateEndpointConnectionArgs.builder()
 *             .cloudHsmClusterName("chsm1")
 *             .peConnectionName("sample-pec")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("My name is Joe and I'm approving this.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rgcloudhsm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:CloudHsmClusterPrivateEndpointConnection sample-pec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/privateEndpointConnections/{peConnectionName}
 * ```
 */
public class CloudHsmClusterPrivateEndpointConnection internal constructor(
    override val javaResource:
    com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, CloudHsmClusterPrivateEndpointConnectionMapper) {
    /**
     * Modified whenever there is a change in the state of private endpoint connection.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The group ids for the private endpoint resource.
     */
    public val groupIds: Output<List<String>>
        get() = javaResource.groupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private endpoint resource.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudHsmClusterPrivateEndpointConnectionMapper :
    ResourceMapper<CloudHsmClusterPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): CloudHsmClusterPrivateEndpointConnection =
        CloudHsmClusterPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection,
        )
}

/**
 * @see [CloudHsmClusterPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudHsmClusterPrivateEndpointConnection].
 */
public suspend fun cloudHsmClusterPrivateEndpointConnection(
    name: String,
    block: suspend CloudHsmClusterPrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    CloudHsmClusterPrivateEndpointConnection {
    val builder = CloudHsmClusterPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudHsmClusterPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudHsmClusterPrivateEndpointConnection(name: String):
    CloudHsmClusterPrivateEndpointConnection {
    val builder = CloudHsmClusterPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
