@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.HardwaresecuritymodulesFunctions.getCloudHsmClusterPlain
import com.pulumi.azurenative.hardwaresecuritymodules.HardwaresecuritymodulesFunctions.getCloudHsmClusterPrivateEndpointConnectionPlain
import com.pulumi.azurenative.hardwaresecuritymodules.HardwaresecuritymodulesFunctions.getDedicatedHsmPlain
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetCloudHsmClusterPlainArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetCloudHsmClusterPlainArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetDedicatedHsmPlainArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.GetDedicatedHsmPlainArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetCloudHsmClusterPrivateEndpointConnectionResult
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetCloudHsmClusterResult
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetDedicatedHsmResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetCloudHsmClusterPrivateEndpointConnectionResult.Companion.toKotlin as getCloudHsmClusterPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetCloudHsmClusterResult.Companion.toKotlin as getCloudHsmClusterResultToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.GetDedicatedHsmResult.Companion.toKotlin as getDedicatedHsmResultToKotlin

public object HardwaresecuritymodulesFunctions {
    /**
     * Gets the specified Cloud HSM Cluster
     * Azure REST API version: 2022-08-31-preview.
     * Other available API versions: 2023-12-10-preview.
     * @param argument null
     * @return Resource information with extended details.
     */
    public suspend fun getCloudHsmCluster(argument: GetCloudHsmClusterPlainArgs):
        GetCloudHsmClusterResult =
        getCloudHsmClusterResultToKotlin(getCloudHsmClusterPlain(argument.toJava()).await())

    /**
     * @see [getCloudHsmCluster].
     * @param cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Resource information with extended details.
     */
    public suspend fun getCloudHsmCluster(cloudHsmClusterName: String, resourceGroupName: String):
        GetCloudHsmClusterResult {
        val argument = GetCloudHsmClusterPlainArgs(
            cloudHsmClusterName = cloudHsmClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudHsmClusterResultToKotlin(getCloudHsmClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudHsmCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hardwaresecuritymodules&#46;kotlin&#46;inputs&#46;GetCloudHsmClusterPlainArgs].
     * @return Resource information with extended details.
     */
    public suspend
    fun getCloudHsmCluster(argument: suspend GetCloudHsmClusterPlainArgsBuilder.() -> Unit):
        GetCloudHsmClusterResult {
        val builder = GetCloudHsmClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudHsmClusterResultToKotlin(getCloudHsmClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the private endpoint connection for the Cloud Hsm Cluster.
     * Azure REST API version: 2022-08-31-preview.
     * Other available API versions: 2023-12-10-preview.
     * @param argument null
     * @return The private endpoint connection resource.
     */
    public suspend
    fun getCloudHsmClusterPrivateEndpointConnection(argument: GetCloudHsmClusterPrivateEndpointConnectionPlainArgs):
        GetCloudHsmClusterPrivateEndpointConnectionResult =
        getCloudHsmClusterPrivateEndpointConnectionResultToKotlin(getCloudHsmClusterPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getCloudHsmClusterPrivateEndpointConnection].
     * @param cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     * @param peConnectionName Name of the private endpoint connection associated with the Cloud HSM Cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The private endpoint connection resource.
     */
    public suspend fun getCloudHsmClusterPrivateEndpointConnection(
        cloudHsmClusterName: String,
        peConnectionName: String,
        resourceGroupName: String,
    ): GetCloudHsmClusterPrivateEndpointConnectionResult {
        val argument = GetCloudHsmClusterPrivateEndpointConnectionPlainArgs(
            cloudHsmClusterName = cloudHsmClusterName,
            peConnectionName = peConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudHsmClusterPrivateEndpointConnectionResultToKotlin(getCloudHsmClusterPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudHsmClusterPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hardwaresecuritymodules&#46;kotlin&#46;inputs&#46;GetCloudHsmClusterPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection resource.
     */
    public suspend
    fun getCloudHsmClusterPrivateEndpointConnection(argument: suspend GetCloudHsmClusterPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetCloudHsmClusterPrivateEndpointConnectionResult {
        val builder = GetCloudHsmClusterPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudHsmClusterPrivateEndpointConnectionResultToKotlin(getCloudHsmClusterPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Azure dedicated HSM.
     * Azure REST API version: 2021-11-30.
     * @param argument null
     * @return Resource information with extended details.
     */
    public suspend fun getDedicatedHsm(argument: GetDedicatedHsmPlainArgs): GetDedicatedHsmResult =
        getDedicatedHsmResultToKotlin(getDedicatedHsmPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHsm].
     * @param name The name of the dedicated HSM.
     * @param resourceGroupName The name of the Resource Group to which the dedicated hsm belongs.
     * @return Resource information with extended details.
     */
    public suspend fun getDedicatedHsm(name: String, resourceGroupName: String):
        GetDedicatedHsmResult {
        val argument = GetDedicatedHsmPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getDedicatedHsmResultToKotlin(getDedicatedHsmPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHsm].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hardwaresecuritymodules&#46;kotlin&#46;inputs&#46;GetDedicatedHsmPlainArgs].
     * @return Resource information with extended details.
     */
    public suspend fun getDedicatedHsm(argument: suspend GetDedicatedHsmPlainArgsBuilder.() -> Unit):
        GetDedicatedHsmResult {
        val builder = GetDedicatedHsmPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHsmResultToKotlin(getDedicatedHsmPlain(builtArgument.toJava()).await())
    }
}
