@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudHsmClusterPlainArgs(
    public val cloudHsmClusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPlainArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPlainArgs.builder()
            .cloudHsmClusterName(cloudHsmClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudHsmClusterPlainArgs].
 */
@PulumiTagMarker
public class GetCloudHsmClusterPlainArgsBuilder internal constructor() {
    private var cloudHsmClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("vcdooqhecgodycus")
    public suspend fun cloudHsmClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudHsmClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qjfwnryhkvqmwaom")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudHsmClusterPlainArgs = GetCloudHsmClusterPlainArgs(
        cloudHsmClusterName = cloudHsmClusterName ?: throw PulumiNullFieldException("cloudHsmClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
