@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseAksClusterProfile
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseClusterPoolProfile
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseComputeProfile
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseLogAnalyticsProfile
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseNetworkProfile
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseAksClusterProfile.Companion.toKotlin as clusterPoolResourcePropertiesResponseAksClusterProfileToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseClusterPoolProfile.Companion.toKotlin as clusterPoolResourcePropertiesResponseClusterPoolProfileToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseComputeProfile.Companion.toKotlin as clusterPoolResourcePropertiesResponseComputeProfileToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseLogAnalyticsProfile.Companion.toKotlin as clusterPoolResourcePropertiesResponseLogAnalyticsProfileToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseNetworkProfile.Companion.toKotlin as clusterPoolResourcePropertiesResponseNetworkProfileToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ClusterPool].
 */
@PulumiTagMarker
public class ClusterPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterPoolArgs = ClusterPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterPoolArgsBuilder.() -> Unit) {
        val builder = ClusterPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterPool {
        val builtJavaResource = com.pulumi.azurenative.hdinsight.ClusterPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterPool(builtJavaResource)
    }
}

/**
 * Cluster pool.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-11-01-preview, 2024-05-01.
 * ## Example Usage
 * ### ClusterPoolPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterPool = new AzureNative.HDInsight.ClusterPool("clusterPool", new()
 *     {
 *         ClusterPoolName = "clusterpool1",
 *         ClusterPoolProfile = new AzureNative.HDInsight.Inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs
 *         {
 *             ClusterPoolVersion = "1.2",
 *         },
 *         ComputeProfile = new AzureNative.HDInsight.Inputs.ClusterPoolResourcePropertiesComputeProfileArgs
 *         {
 *             VmSize = "Standard_D3_v2",
 *         },
 *         Location = "West US 2",
 *         ResourceGroupName = "hiloResourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewClusterPool(ctx, "clusterPool", &hdinsight.ClusterPoolArgs{
 * 			ClusterPoolName: pulumi.String("clusterpool1"),
 * 			ClusterPoolProfile: &hdinsight.ClusterPoolResourcePropertiesClusterPoolProfileArgs{
 * 				ClusterPoolVersion: pulumi.String("1.2"),
 * 			},
 * 			ComputeProfile: &hdinsight.ClusterPoolResourcePropertiesComputeProfileArgs{
 * 				VmSize: pulumi.String("Standard_D3_v2"),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("hiloResourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.ClusterPool;
 * import com.pulumi.azurenative.hdinsight.ClusterPoolArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesComputeProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterPool = new ClusterPool("clusterPool", ClusterPoolArgs.builder()
 *             .clusterPoolName("clusterpool1")
 *             .clusterPoolProfile(ClusterPoolResourcePropertiesClusterPoolProfileArgs.builder()
 *                 .clusterPoolVersion("1.2")
 *                 .build())
 *             .computeProfile(ClusterPoolResourcePropertiesComputeProfileArgs.builder()
 *                 .vmSize("Standard_D3_v2")
 *                 .build())
 *             .location("West US 2")
 *             .resourceGroupName("hiloResourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:ClusterPool clusterpool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusterpools/{clusterPoolName}
 * ```
 */
public class ClusterPool internal constructor(
    override val javaResource: com.pulumi.azurenative.hdinsight.ClusterPool,
) : KotlinCustomResource(javaResource, ClusterPoolMapper) {
    /**
     * Properties of underlying AKS cluster.
     */
    public val aksClusterProfile: Output<ClusterPoolResourcePropertiesResponseAksClusterProfile>
        get() = javaResource.aksClusterProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterPoolResourcePropertiesResponseAksClusterProfileToKotlin(args0)
            })
        })

    /**
     * A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool name and managed resource group name by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}
     */
    public val aksManagedResourceGroupName: Output<String>
        get() = javaResource.aksManagedResourceGroupName().applyValue({ args0 -> args0 })

    /**
     * CLuster pool profile.
     */
    public val clusterPoolProfile: Output<ClusterPoolResourcePropertiesResponseClusterPoolProfile>?
        get() = javaResource.clusterPoolProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterPoolResourcePropertiesResponseClusterPoolProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * CLuster pool compute profile.
     */
    public val computeProfile: Output<ClusterPoolResourcePropertiesResponseComputeProfile>
        get() = javaResource.computeProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterPoolResourcePropertiesResponseComputeProfileToKotlin(args0)
            })
        })

    /**
     * A unique id generated by the RP to identify the resource.
     */
    public val deploymentId: Output<String>
        get() = javaResource.deploymentId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Cluster pool log analytics profile to enable OMS agent for AKS cluster.
     */
    public val logAnalyticsProfile: Output<ClusterPoolResourcePropertiesResponseLogAnalyticsProfile>?
        get() = javaResource.logAnalyticsProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterPoolResourcePropertiesResponseLogAnalyticsProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
     */
    public val managedResourceGroupName: Output<String>?
        get() = javaResource.managedResourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Cluster pool network profile.
     */
    public val networkProfile: Output<ClusterPoolResourcePropertiesResponseNetworkProfile>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterPoolResourcePropertiesResponseNetworkProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Business status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClusterPoolMapper : ResourceMapper<ClusterPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hdinsight.ClusterPool::class == javaResource::class

    override fun map(javaResource: Resource): ClusterPool = ClusterPool(
        javaResource as
            com.pulumi.azurenative.hdinsight.ClusterPool,
    )
}

/**
 * @see [ClusterPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterPool].
 */
public suspend fun clusterPool(name: String, block: suspend ClusterPoolResourceBuilder.() -> Unit):
    ClusterPool {
    val builder = ClusterPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterPool(name: String): ClusterPool {
    val builder = ClusterPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
