@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.HdinsightFunctions.getApplicationPlain
import com.pulumi.azurenative.hdinsight.HdinsightFunctions.getClusterGatewaySettingsPlain
import com.pulumi.azurenative.hdinsight.HdinsightFunctions.getClusterPlain
import com.pulumi.azurenative.hdinsight.HdinsightFunctions.getClusterPoolPlain
import com.pulumi.azurenative.hdinsight.HdinsightFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterGatewaySettingsPlainArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterGatewaySettingsPlainArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterPoolPlainArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetClusterPoolPlainArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterGatewaySettingsResult
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterPoolResult
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetPrivateEndpointConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterGatewaySettingsResult.Companion.toKotlin as getClusterGatewaySettingsResultToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterPoolResult.Companion.toKotlin as getClusterPoolResultToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin

public object HdinsightFunctions {
    /**
     * Gets properties of the specified application.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
     * @param argument null
     * @return The HDInsight cluster application
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationName The constant value for the application name.
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group.
     * @return The HDInsight cluster application
     */
    public suspend fun getApplication(
        applicationName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationName = applicationName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hdinsight&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return The HDInsight cluster application
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit):
        GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified cluster.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2023-04-15-preview, 2023-06-01-preview, 2023-08-15-preview, 2023-11-01-preview, 2024-05-01.
     * @param argument null
     * @return The HDInsight cluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group.
     * @return The HDInsight cluster.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hdinsight&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return The HDInsight cluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the gateway settings for the specified cluster.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
     * @param argument null
     * @return Gateway settings.
     */
    public suspend fun getClusterGatewaySettings(argument: GetClusterGatewaySettingsPlainArgs):
        GetClusterGatewaySettingsResult =
        getClusterGatewaySettingsResultToKotlin(getClusterGatewaySettingsPlain(argument.toJava()).await())

    /**
     * @see [getClusterGatewaySettings].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group.
     * @return Gateway settings.
     */
    public suspend fun getClusterGatewaySettings(clusterName: String, resourceGroupName: String):
        GetClusterGatewaySettingsResult {
        val argument = GetClusterGatewaySettingsPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterGatewaySettingsResultToKotlin(getClusterGatewaySettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterGatewaySettings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hdinsight&#46;kotlin&#46;inputs&#46;GetClusterGatewaySettingsPlainArgs].
     * @return Gateway settings.
     */
    public suspend
    fun getClusterGatewaySettings(argument: suspend GetClusterGatewaySettingsPlainArgsBuilder.() -> Unit):
        GetClusterGatewaySettingsResult {
        val builder = GetClusterGatewaySettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterGatewaySettingsResultToKotlin(getClusterGatewaySettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a cluster pool.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-11-01-preview, 2024-05-01.
     * @param argument null
     * @return Cluster pool.
     */
    public suspend fun getClusterPool(argument: GetClusterPoolPlainArgs): GetClusterPoolResult =
        getClusterPoolResultToKotlin(getClusterPoolPlain(argument.toJava()).await())

    /**
     * @see [getClusterPool].
     * @param clusterPoolName The name of the cluster pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cluster pool.
     */
    public suspend fun getClusterPool(clusterPoolName: String, resourceGroupName: String):
        GetClusterPoolResult {
        val argument = GetClusterPoolPlainArgs(
            clusterPoolName = clusterPoolName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterPoolResultToKotlin(getClusterPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hdinsight&#46;kotlin&#46;inputs&#46;GetClusterPoolPlainArgs].
     * @return Cluster pool.
     */
    public suspend fun getClusterPool(argument: suspend GetClusterPoolPlainArgsBuilder.() -> Unit):
        GetClusterPoolResult {
        val builder = GetClusterPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterPoolResultToKotlin(getClusterPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specific private endpoint connection.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
     * @param argument null
     * @return The private endpoint connection.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param clusterName The name of the cluster.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group.
     * @return The private endpoint connection.
     */
    public suspend fun getPrivateEndpointConnection(
        clusterName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            clusterName = clusterName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hdinsight&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }
}
