@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.AutoscaleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The autoscale request parameters
 * @property capacity Parameters for load-based autoscale
 * @property recurrence Parameters for schedule-based autoscale
 */
public data class AutoscaleArgs(
    public val capacity: Output<AutoscaleCapacityArgs>? = null,
    public val recurrence: Output<AutoscaleRecurrenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.AutoscaleArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.AutoscaleArgs =
        com.pulumi.azurenative.hdinsight.inputs.AutoscaleArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AutoscaleArgs].
 */
@PulumiTagMarker
public class AutoscaleArgsBuilder internal constructor() {
    private var capacity: Output<AutoscaleCapacityArgs>? = null

    private var recurrence: Output<AutoscaleRecurrenceArgs>? = null

    /**
     * @param value Parameters for load-based autoscale
     */
    @JvmName("gbcuiawimqkqvpbw")
    public suspend fun capacity(`value`: Output<AutoscaleCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value Parameters for schedule-based autoscale
     */
    @JvmName("mnadbsvrkwgavmxn")
    public suspend fun recurrence(`value`: Output<AutoscaleRecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value Parameters for load-based autoscale
     */
    @JvmName("fhcdolkmebkvlwrk")
    public suspend fun capacity(`value`: AutoscaleCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument Parameters for load-based autoscale
     */
    @JvmName("apjkhmfhaydydcsd")
    public suspend fun capacity(argument: suspend AutoscaleCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = AutoscaleCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value Parameters for schedule-based autoscale
     */
    @JvmName("uwyhojrnwjynwjgi")
    public suspend fun recurrence(`value`: AutoscaleRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument Parameters for schedule-based autoscale
     */
    @JvmName("rbetersmwxnejsjd")
    public suspend fun recurrence(argument: suspend AutoscaleRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = AutoscaleRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    internal fun build(): AutoscaleArgs = AutoscaleArgs(
        capacity = capacity,
        recurrence = recurrence,
    )
}
