@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterIdentityArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Identity for the cluster.
 * @property type The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
 * @property userAssignedIdentities The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ClusterIdentityArgs(
    public val type: Output<Either<String, ResourceIdentityType>>? = null,
    public val userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClusterIdentityArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterIdentityArgs].
 */
@PulumiTagMarker
public class ClusterIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ResourceIdentityType>>? = null

    private var userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null

    /**
     * @param value The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
     */
    @JvmName("wxnutiufywkqmpwt")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("hitabltdrhxihwvp")
    public suspend
    fun userAssignedIdentities(`value`: Output<Map<String, UserAssignedIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
     */
    @JvmName("irpapacfrxmyhevb")
    public suspend fun type(`value`: Either<String, ResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
     */
    @JvmName("betghsxtbgbhytxy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
     */
    @JvmName("afyomommngyjxwjv")
    public fun type(`value`: ResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("jneyfdvaofafraqb")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("rvnrtfwjktwisnsi")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserAssignedIdentityArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("hyuwgysyufgqtxih")
    public fun userAssignedIdentities(vararg values: Pair<String, UserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ClusterIdentityArgs = ClusterIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
