@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CLuster pool profile.
 * @property clusterPoolVersion Cluster pool version is a 2-part version.
 */
public data class ClusterPoolResourcePropertiesClusterPoolProfileArgs(
    public val clusterPoolVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs.builder()
            .clusterPoolVersion(clusterPoolVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPoolResourcePropertiesClusterPoolProfileArgs].
 */
@PulumiTagMarker
public class ClusterPoolResourcePropertiesClusterPoolProfileArgsBuilder internal constructor() {
    private var clusterPoolVersion: Output<String>? = null

    /**
     * @param value Cluster pool version is a 2-part version.
     */
    @JvmName("upmubaenmuwyyxuj")
    public suspend fun clusterPoolVersion(`value`: Output<String>) {
        this.clusterPoolVersion = value
    }

    /**
     * @param value Cluster pool version is a 2-part version.
     */
    @JvmName("lkuaoahfvannycik")
    public suspend fun clusterPoolVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterPoolVersion = mapped
    }

    internal fun build(): ClusterPoolResourcePropertiesClusterPoolProfileArgs =
        ClusterPoolResourcePropertiesClusterPoolProfileArgs(
            clusterPoolVersion = clusterPoolVersion ?: throw PulumiNullFieldException("clusterPoolVersion"),
        )
}
