@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ErrorsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The error message associated with the cluster creation.
 * @property code The error code.
 * @property message The error message.
 */
public data class ErrorsArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ErrorsArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ErrorsArgs =
        com.pulumi.azurenative.hdinsight.inputs.ErrorsArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErrorsArgs].
 */
@PulumiTagMarker
public class ErrorsArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value The error code.
     */
    @JvmName("iygmnyvcdsbjrkoj")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The error message.
     */
    @JvmName("ygtqqissomkddwmd")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The error code.
     */
    @JvmName("emimxwppqrqmpamd")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The error message.
     */
    @JvmName("tswhbuvflqvigtms")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): ErrorsArgs = ErrorsArgs(
        code = code,
        message = message,
    )
}
