@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.PrivateLinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The private link configuration.
 * @property groupId The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
 * @property ipConfigurations The IP configurations for the private link service.
 * @property name The name of private link configuration.
 */
public data class PrivateLinkConfigurationArgs(
    public val groupId: Output<String>,
    public val ipConfigurations: Output<List<IPConfigurationArgs>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.PrivateLinkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.PrivateLinkConfigurationArgs =
        com.pulumi.azurenative.hdinsight.inputs.PrivateLinkConfigurationArgs.builder()
            .groupId(groupId.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkConfigurationArgs].
 */
@PulumiTagMarker
public class PrivateLinkConfigurationArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var ipConfigurations: Output<List<IPConfigurationArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
     */
    @JvmName("vlgjpodglpcvlxjl")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The IP configurations for the private link service.
     */
    @JvmName("jcuqqraxdqwawfky")
    public suspend fun ipConfigurations(`value`: Output<List<IPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("wahwxjumxhklscpn")
    public suspend fun ipConfigurations(vararg values: Output<IPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The IP configurations for the private link service.
     */
    @JvmName("anyhdjyudwfxwqcs")
    public suspend fun ipConfigurations(values: List<Output<IPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The name of private link configuration.
     */
    @JvmName("axpnojqulmlsdrxs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
     */
    @JvmName("hbdsfqhikyywhjnk")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The IP configurations for the private link service.
     */
    @JvmName("inouxuslyovvlgkf")
    public suspend fun ipConfigurations(`value`: List<IPConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument The IP configurations for the private link service.
     */
    @JvmName("nnftoiylqkorabte")
    public suspend
    fun ipConfigurations(argument: List<suspend IPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument The IP configurations for the private link service.
     */
    @JvmName("unakrcrcydippjix")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend IPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument The IP configurations for the private link service.
     */
    @JvmName("ccmjivvbldpmwqoq")
    public suspend fun ipConfigurations(argument: suspend IPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values The IP configurations for the private link service.
     */
    @JvmName("plvmwqvblysbsngw")
    public suspend fun ipConfigurations(vararg values: IPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The name of private link configuration.
     */
    @JvmName("thkcioxtwcujogyn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PrivateLinkConfigurationArgs = PrivateLinkConfigurationArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        ipConfigurations = ipConfigurations ?: throw PulumiNullFieldException("ipConfigurations"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
