@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.SecurityProfileArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.DirectoryType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The security profile which contains Ssh public key for the HDInsight cluster.
 * @property aaddsResourceId The resource ID of the user's Azure Active Directory Domain Service.
 * @property clusterUsersGroupDNs Optional. The Distinguished Names for cluster user groups
 * @property directoryType The directory type.
 * @property domain The organization's active directory domain.
 * @property domainUserPassword The domain admin password.
 * @property domainUsername The domain user account that will have admin privileges on the cluster.
 * @property ldapsUrls The LDAPS protocol URLs to communicate with the Active Directory.
 * @property msiResourceId User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
 * @property organizationalUnitDN The organizational unit within the Active Directory to place the cluster and service accounts.
 */
public data class SecurityProfileArgs(
    public val aaddsResourceId: Output<String>? = null,
    public val clusterUsersGroupDNs: Output<List<String>>? = null,
    public val directoryType: Output<Either<String, DirectoryType>>? = null,
    public val domain: Output<String>? = null,
    public val domainUserPassword: Output<String>? = null,
    public val domainUsername: Output<String>? = null,
    public val ldapsUrls: Output<List<String>>? = null,
    public val msiResourceId: Output<String>? = null,
    public val organizationalUnitDN: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.SecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.SecurityProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.SecurityProfileArgs.builder()
            .aaddsResourceId(aaddsResourceId?.applyValue({ args0 -> args0 }))
            .clusterUsersGroupDNs(clusterUsersGroupDNs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .directoryType(
                directoryType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainUserPassword(domainUserPassword?.applyValue({ args0 -> args0 }))
            .domainUsername(domainUsername?.applyValue({ args0 -> args0 }))
            .ldapsUrls(ldapsUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .msiResourceId(msiResourceId?.applyValue({ args0 -> args0 }))
            .organizationalUnitDN(organizationalUnitDN?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityProfileArgs].
 */
@PulumiTagMarker
public class SecurityProfileArgsBuilder internal constructor() {
    private var aaddsResourceId: Output<String>? = null

    private var clusterUsersGroupDNs: Output<List<String>>? = null

    private var directoryType: Output<Either<String, DirectoryType>>? = null

    private var domain: Output<String>? = null

    private var domainUserPassword: Output<String>? = null

    private var domainUsername: Output<String>? = null

    private var ldapsUrls: Output<List<String>>? = null

    private var msiResourceId: Output<String>? = null

    private var organizationalUnitDN: Output<String>? = null

    /**
     * @param value The resource ID of the user's Azure Active Directory Domain Service.
     */
    @JvmName("ycbwwodyriqowuhn")
    public suspend fun aaddsResourceId(`value`: Output<String>) {
        this.aaddsResourceId = value
    }

    /**
     * @param value Optional. The Distinguished Names for cluster user groups
     */
    @JvmName("jjcoxagfbppsibwm")
    public suspend fun clusterUsersGroupDNs(`value`: Output<List<String>>) {
        this.clusterUsersGroupDNs = value
    }

    @JvmName("tyvxmqadjroqutfn")
    public suspend fun clusterUsersGroupDNs(vararg values: Output<String>) {
        this.clusterUsersGroupDNs = Output.all(values.asList())
    }

    /**
     * @param values Optional. The Distinguished Names for cluster user groups
     */
    @JvmName("bdrwtgqlcnlytafn")
    public suspend fun clusterUsersGroupDNs(values: List<Output<String>>) {
        this.clusterUsersGroupDNs = Output.all(values)
    }

    /**
     * @param value The directory type.
     */
    @JvmName("wcswtjomhyuqglkh")
    public suspend fun directoryType(`value`: Output<Either<String, DirectoryType>>) {
        this.directoryType = value
    }

    /**
     * @param value The organization's active directory domain.
     */
    @JvmName("tdegqhdhtbsyvmlf")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The domain admin password.
     */
    @JvmName("urihsvqwfdkdsqve")
    public suspend fun domainUserPassword(`value`: Output<String>) {
        this.domainUserPassword = value
    }

    /**
     * @param value The domain user account that will have admin privileges on the cluster.
     */
    @JvmName("hvxqbooqiarwimuw")
    public suspend fun domainUsername(`value`: Output<String>) {
        this.domainUsername = value
    }

    /**
     * @param value The LDAPS protocol URLs to communicate with the Active Directory.
     */
    @JvmName("thmgdcorinepavje")
    public suspend fun ldapsUrls(`value`: Output<List<String>>) {
        this.ldapsUrls = value
    }

    @JvmName("gbcfqfeuhoovhxsm")
    public suspend fun ldapsUrls(vararg values: Output<String>) {
        this.ldapsUrls = Output.all(values.asList())
    }

    /**
     * @param values The LDAPS protocol URLs to communicate with the Active Directory.
     */
    @JvmName("jwrdoutymrwjogkq")
    public suspend fun ldapsUrls(values: List<Output<String>>) {
        this.ldapsUrls = Output.all(values)
    }

    /**
     * @param value User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
     */
    @JvmName("erjrkwgmemrsqynd")
    public suspend fun msiResourceId(`value`: Output<String>) {
        this.msiResourceId = value
    }

    /**
     * @param value The organizational unit within the Active Directory to place the cluster and service accounts.
     */
    @JvmName("kojjxaeyheyffncn")
    public suspend fun organizationalUnitDN(`value`: Output<String>) {
        this.organizationalUnitDN = value
    }

    /**
     * @param value The resource ID of the user's Azure Active Directory Domain Service.
     */
    @JvmName("tnaudwguduajhjaf")
    public suspend fun aaddsResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aaddsResourceId = mapped
    }

    /**
     * @param value Optional. The Distinguished Names for cluster user groups
     */
    @JvmName("cnmyqheysauxoyvo")
    public suspend fun clusterUsersGroupDNs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterUsersGroupDNs = mapped
    }

    /**
     * @param values Optional. The Distinguished Names for cluster user groups
     */
    @JvmName("dpogjfllhnctlscm")
    public suspend fun clusterUsersGroupDNs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUsersGroupDNs = mapped
    }

    /**
     * @param value The directory type.
     */
    @JvmName("dmpgwlmwvhodansi")
    public suspend fun directoryType(`value`: Either<String, DirectoryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryType = mapped
    }

    /**
     * @param value The directory type.
     */
    @JvmName("rmqaonfdnppsqwiy")
    public fun directoryType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DirectoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryType = mapped
    }

    /**
     * @param value The directory type.
     */
    @JvmName("escdkstmbfnxpopb")
    public fun directoryType(`value`: DirectoryType) {
        val toBeMapped = Either.ofRight<String, DirectoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryType = mapped
    }

    /**
     * @param value The organization's active directory domain.
     */
    @JvmName("ulvxmlgufcvcrsch")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The domain admin password.
     */
    @JvmName("bxruipqwnioeuwos")
    public suspend fun domainUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUserPassword = mapped
    }

    /**
     * @param value The domain user account that will have admin privileges on the cluster.
     */
    @JvmName("efajcugrwjukkofk")
    public suspend fun domainUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUsername = mapped
    }

    /**
     * @param value The LDAPS protocol URLs to communicate with the Active Directory.
     */
    @JvmName("vourbxicamqajadl")
    public suspend fun ldapsUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapsUrls = mapped
    }

    /**
     * @param values The LDAPS protocol URLs to communicate with the Active Directory.
     */
    @JvmName("tosgrndhcrlkhymq")
    public suspend fun ldapsUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldapsUrls = mapped
    }

    /**
     * @param value User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
     */
    @JvmName("jtudgwqkrmevqkxe")
    public suspend fun msiResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msiResourceId = mapped
    }

    /**
     * @param value The organizational unit within the Active Directory to place the cluster and service accounts.
     */
    @JvmName("nnpywhsexaltsmul")
    public suspend fun organizationalUnitDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitDN = mapped
    }

    internal fun build(): SecurityProfileArgs = SecurityProfileArgs(
        aaddsResourceId = aaddsResourceId,
        clusterUsersGroupDNs = clusterUsersGroupDNs,
        directoryType = directoryType,
        domain = domain,
        domainUserPassword = domainUserPassword,
        domainUsername = domainUsername,
        ldapsUrls = ldapsUrls,
        msiResourceId = msiResourceId,
        organizationalUnitDN = organizationalUnitDN,
    )
}
