@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
 * @property days Days of the week for a schedule-based autoscale rule
 * @property timeAndCapacity Time and capacity for a schedule-based autoscale rule
 */
public data class AutoscaleScheduleResponse(
    public val days: List<String>? = null,
    public val timeAndCapacity: AutoscaleTimeAndCapacityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AutoscaleScheduleResponse):
            AutoscaleScheduleResponse = AutoscaleScheduleResponse(
            days = javaType.days().map({ args0 -> args0 }),
            timeAndCapacity = javaType.timeAndCapacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.AutoscaleTimeAndCapacityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
