@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity for the cluster.
 * @property principalId The principal id of cluster identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
 * @property type The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
 * @property userAssignedIdentities The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ClusterIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClusterIdentityResponse):
            ClusterIdentityResponse = ClusterIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.hdinsight.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
