@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * CLuster pool compute profile.
 * @property count The number of virtual machines.
 * @property vmSize The virtual machine SKU.
 */
public data class ClusterPoolResourcePropertiesResponseComputeProfile(
    public val count: Int,
    public val vmSize: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClusterPoolResourcePropertiesResponseComputeProfile):
            ClusterPoolResourcePropertiesResponseComputeProfile =
            ClusterPoolResourcePropertiesResponseComputeProfile(
                count = javaType.count(),
                vmSize = javaType.vmSize(),
            )
    }
}
