@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The disk encryption properties
 * @property encryptionAlgorithm Algorithm identifier for encryption, default RSA-OAEP.
 * @property encryptionAtHost Indicates whether or not resource disk encryption is enabled.
 * @property keyName Key name that is used for enabling disk encryption.
 * @property keyVersion Specific key version that is used for enabling disk encryption.
 * @property msiResourceId Resource ID of Managed Identity that is used to access the key vault.
 * @property vaultUri Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
 */
public data class DiskEncryptionPropertiesResponse(
    public val encryptionAlgorithm: String? = null,
    public val encryptionAtHost: Boolean? = null,
    public val keyName: String? = null,
    public val keyVersion: String? = null,
    public val msiResourceId: String? = null,
    public val vaultUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.DiskEncryptionPropertiesResponse):
            DiskEncryptionPropertiesResponse = DiskEncryptionPropertiesResponse(
            encryptionAlgorithm = javaType.encryptionAlgorithm().map({ args0 -> args0 }).orElse(null),
            encryptionAtHost = javaType.encryptionAtHost().map({ args0 -> args0 }).orElse(null),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            msiResourceId = javaType.msiResourceId().map({ args0 -> args0 }).orElse(null),
            vaultUri = javaType.vaultUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
