@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gateway settings.
 * @property isCredentialEnabled Indicates whether or not the gateway settings based authorization is enabled.
 * @property password The gateway settings user password.
 * @property userName The gateway settings user name.
 */
public data class GetClusterGatewaySettingsResult(
    public val isCredentialEnabled: String,
    public val password: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.GetClusterGatewaySettingsResult):
            GetClusterGatewaySettingsResult = GetClusterGatewaySettingsResult(
            isCredentialEnabled = javaType.isCredentialEnabled(),
            password = javaType.password(),
            userName = javaType.userName(),
        )
    }
}
