@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The storage Account.
 * @property container The container in the storage account, only to be specified for WASB storage accounts.
 * @property fileSystem The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
 * @property fileshare The file share name.
 * @property isDefault Whether or not the storage account is the default storage account.
 * @property key The storage account access key.
 * @property msiResourceId The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
 * @property name The name of the storage account.
 * @property resourceId The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
 * @property saskey The shared access signature key.
 */
public data class StorageAccountResponse(
    public val container: String? = null,
    public val fileSystem: String? = null,
    public val fileshare: String? = null,
    public val isDefault: Boolean? = null,
    public val key: String? = null,
    public val msiResourceId: String? = null,
    public val name: String? = null,
    public val resourceId: String? = null,
    public val saskey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.StorageAccountResponse):
            StorageAccountResponse = StorageAccountResponse(
            container = javaType.container().map({ args0 -> args0 }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 -> args0 }).orElse(null),
            fileshare = javaType.fileshare().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            msiResourceId = javaType.msiResourceId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            saskey = javaType.saskey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
