@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin

import com.pulumi.azurenative.healthbot.BotArgs.builder
import com.pulumi.azurenative.healthbot.kotlin.inputs.HealthBotPropertiesArgs
import com.pulumi.azurenative.healthbot.kotlin.inputs.HealthBotPropertiesArgsBuilder
import com.pulumi.azurenative.healthbot.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.healthbot.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.healthbot.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.healthbot.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Health Bot resource definition
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-12-08.
 * Other available API versions: 2020-12-08-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthbot:Bot samplebotname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthBot/healthBots/{botName}
 * ```
 * @property botName The name of the Bot resource.
 * @property identity The identity of the Azure Health Bot.
 * @property location The geo-location where the resource lives
 * @property properties The set of properties specific to Azure Health Bot resource.
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property sku SKU of the Azure Health Bot.
 * @property tags Resource tags.
 */
public data class BotArgs(
    public val botName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<HealthBotPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.BotArgs> {
    override fun toJava(): com.pulumi.azurenative.healthbot.BotArgs =
        com.pulumi.azurenative.healthbot.BotArgs.builder()
            .botName(botName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BotArgs].
 */
@PulumiTagMarker
public class BotArgsBuilder internal constructor() {
    private var botName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<HealthBotPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("ohbvtqxjsmjbuych")
    public suspend fun botName(`value`: Output<String>) {
        this.botName = value
    }

    /**
     * @param value The identity of the Azure Health Bot.
     */
    @JvmName("sscexcqnwflaqbob")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dwpwdgtadhtnvhon")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to Azure Health Bot resource.
     */
    @JvmName("uxhtjtfxjdgbqvqg")
    public suspend fun properties(`value`: Output<HealthBotPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("pgpvsuuxhtvlmqdg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU of the Azure Health Bot.
     */
    @JvmName("ekejpslnyyqcpyhi")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fgwqirwwgnaxintj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("hcbxynqqahybufop")
    public suspend fun botName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botName = mapped
    }

    /**
     * @param value The identity of the Azure Health Bot.
     */
    @JvmName("wnyhwpdjwvjxepyi")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the Azure Health Bot.
     */
    @JvmName("vqgxyjextpbpmuio")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dugvowlhhwyopsvu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to Azure Health Bot resource.
     */
    @JvmName("rhixbxtykwsyqyrl")
    public suspend fun properties(`value`: HealthBotPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to Azure Health Bot resource.
     */
    @JvmName("kbgciydlgloaljxo")
    public suspend fun properties(argument: suspend HealthBotPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = HealthBotPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("npsjifddoglcxrrw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU of the Azure Health Bot.
     */
    @JvmName("jvyglqushpglrjiw")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the Azure Health Bot.
     */
    @JvmName("ivtwxslysklrixem")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pavjfmucisnqfarh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wpsfhtwurecbcasl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BotArgs = BotArgs(
        botName = botName,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
