@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.inputs

import com.pulumi.azurenative.healthbot.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the key vault.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The Uri of the key vault.
 * @property keyVersion The version of the key vault key.
 * @property userIdentity The user assigned identity (ARM resource id) that has access to the key.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>? = null,
    public val userIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.healthbot.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.healthbot.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 }))
            .userIdentity(userIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var userIdentity: Output<String>? = null

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("hgwotuspojvrxumt")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The Uri of the key vault.
     */
    @JvmName("fxxbxpwpgygpthcd")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of the key vault key.
     */
    @JvmName("cvtyuwhshkpkjufb")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The user assigned identity (ARM resource id) that has access to the key.
     */
    @JvmName("olmddrnmdcheojgg")
    public suspend fun userIdentity(`value`: Output<String>) {
        this.userIdentity = value
    }

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("gixnyagfrhvtadcf")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The Uri of the key vault.
     */
    @JvmName("wbjwaayqxjgdqiqm")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of the key vault key.
     */
    @JvmName("jhlngqdqkcrkgnwn")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value The user assigned identity (ARM resource id) that has access to the key.
     */
    @JvmName("voxghodsstljnqjg")
    public suspend fun userIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIdentity = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        keyVersion = keyVersion,
        userIdentity = userIdentity,
    )
}
