@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.FhirServiceArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.FhirServiceKind
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAccessPolicyEntryArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAccessPolicyEntryArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAcrConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAcrConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAuthenticationConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceAuthenticationConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceCorsConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceCorsConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceExportConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceExportConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceImportConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.FhirServiceImportConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ImplementationGuidesConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ImplementationGuidesConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ResourceVersionPolicyConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ResourceVersionPolicyConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of Fhir Service
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
 * ## Example Usage
 * ### Create or update a Fhir Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fhirService = new AzureNative.HealthcareApis.FhirService("fhirService", new()
 *     {
 *         AccessPolicies = new[]
 *         {
 *             new AzureNative.HealthcareApis.Inputs.FhirServiceAccessPolicyEntryArgs
 *             {
 *                 ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *             },
 *             new AzureNative.HealthcareApis.Inputs.FhirServiceAccessPolicyEntryArgs
 *             {
 *                 ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *             },
 *         },
 *         AcrConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceAcrConfigurationArgs
 *         {
 *             LoginServers = new[]
 *             {
 *                 "test1.azurecr.io",
 *             },
 *         },
 *         AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceAuthenticationConfigurationArgs
 *         {
 *             Audience = "https://azurehealthcareapis.com",
 *             Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *             SmartProxyEnabled = true,
 *         },
 *         CorsConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceCorsConfigurationArgs
 *         {
 *             AllowCredentials = false,
 *             Headers = new[]
 *             {
 *                 "*",
 *             },
 *             MaxAge = 1440,
 *             Methods = new[]
 *             {
 *                 "DELETE",
 *                 "GET",
 *                 "OPTIONS",
 *                 "PATCH",
 *                 "POST",
 *                 "PUT",
 *             },
 *             Origins = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *         ExportConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceExportConfigurationArgs
 *         {
 *             StorageAccountName = "existingStorageAccount",
 *         },
 *         FhirServiceName = "fhirservice1",
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServiceManagedIdentityIdentityArgs
 *         {
 *             Type = AzureNative.HealthcareApis.ServiceManagedIdentityType.SystemAssigned,
 *         },
 *         ImplementationGuidesConfiguration = new AzureNative.HealthcareApis.Inputs.ImplementationGuidesConfigurationArgs
 *         {
 *             UsCoreMissingData = false,
 *         },
 *         ImportConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceImportConfigurationArgs
 *         {
 *             Enabled = false,
 *             InitialImportMode = false,
 *             IntegrationDataStore = "existingStorageAccount",
 *         },
 *         Kind = AzureNative.HealthcareApis.FhirServiceKind.Fhir_R4,
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "additionalProp1", "string" },
 *             { "additionalProp2", "string" },
 *             { "additionalProp3", "string" },
 *         },
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewFhirService(ctx, "fhirService", &healthcareapis.FhirServiceArgs{
 * 			AccessPolicies: healthcareapis.FhirServiceAccessPolicyEntryArray{
 * 				&healthcareapis.FhirServiceAccessPolicyEntryArgs{
 * 					ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 				},
 * 				&healthcareapis.FhirServiceAccessPolicyEntryArgs{
 * 					ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 				},
 * 			},
 * 			AcrConfiguration: &healthcareapis.FhirServiceAcrConfigurationArgs{
 * 				LoginServers: pulumi.StringArray{
 * 					pulumi.String("test1.azurecr.io"),
 * 				},
 * 			},
 * 			AuthenticationConfiguration: &healthcareapis.FhirServiceAuthenticationConfigurationArgs{
 * 				Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 				Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 				SmartProxyEnabled: pulumi.Bool(true),
 * 			},
 * 			CorsConfiguration: &healthcareapis.FhirServiceCorsConfigurationArgs{
 * 				AllowCredentials: pulumi.Bool(false),
 * 				Headers: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				MaxAge: pulumi.Int(1440),
 * 				Methods: pulumi.StringArray{
 * 					pulumi.String("DELETE"),
 * 					pulumi.String("GET"),
 * 					pulumi.String("OPTIONS"),
 * 					pulumi.String("PATCH"),
 * 					pulumi.String("POST"),
 * 					pulumi.String("PUT"),
 * 				},
 * 				Origins: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 			ExportConfiguration: &healthcareapis.FhirServiceExportConfigurationArgs{
 * 				StorageAccountName: pulumi.String("existingStorageAccount"),
 * 			},
 * 			FhirServiceName: pulumi.String("fhirservice1"),
 * 			Identity: &healthcareapis.ServiceManagedIdentityIdentityArgs{
 * 				Type: pulumi.String(healthcareapis.ServiceManagedIdentityTypeSystemAssigned),
 * 			},
 * 			ImplementationGuidesConfiguration: &healthcareapis.ImplementationGuidesConfigurationArgs{
 * 				UsCoreMissingData: pulumi.Bool(false),
 * 			},
 * 			ImportConfiguration: &healthcareapis.FhirServiceImportConfigurationArgs{
 * 				Enabled:              pulumi.Bool(false),
 * 				InitialImportMode:    pulumi.Bool(false),
 * 				IntegrationDataStore: pulumi.String("existingStorageAccount"),
 * 			},
 * 			Kind:              pulumi.String(healthcareapis.FhirServiceKind_Fhir_R4),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("string"),
 * 				"additionalProp2": pulumi.String("string"),
 * 				"additionalProp3": pulumi.String("string"),
 * 			},
 * 			WorkspaceName: pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.FhirService;
 * import com.pulumi.azurenative.healthcareapis.FhirServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAccessPolicyEntryArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAcrConfigurationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAuthenticationConfigurationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceCorsConfigurationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceExportConfigurationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceManagedIdentityIdentityArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ImplementationGuidesConfigurationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceImportConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fhirService = new FhirService("fhirService", FhirServiceArgs.builder()
 *             .accessPolicies(
 *                 FhirServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                     .build(),
 *                 FhirServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                     .build())
 *             .acrConfiguration(FhirServiceAcrConfigurationArgs.builder()
 *                 .loginServers("test1.azurecr.io")
 *                 .build())
 *             .authenticationConfiguration(FhirServiceAuthenticationConfigurationArgs.builder()
 *                 .audience("https://azurehealthcareapis.com")
 *                 .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                 .smartProxyEnabled(true)
 *                 .build())
 *             .corsConfiguration(FhirServiceCorsConfigurationArgs.builder()
 *                 .allowCredentials(false)
 *                 .headers("*")
 *                 .maxAge(1440)
 *                 .methods(
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT")
 *                 .origins("*")
 *                 .build())
 *             .exportConfiguration(FhirServiceExportConfigurationArgs.builder()
 *                 .storageAccountName("existingStorageAccount")
 *                 .build())
 *             .fhirServiceName("fhirservice1")
 *             .identity(ServiceManagedIdentityIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .implementationGuidesConfiguration(ImplementationGuidesConfigurationArgs.builder()
 *                 .usCoreMissingData(false)
 *                 .build())
 *             .importConfiguration(FhirServiceImportConfigurationArgs.builder()
 *                 .enabled(false)
 *                 .initialImportMode(false)
 *                 .integrationDataStore("existingStorageAccount")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("additionalProp1", "string"),
 *                 Map.entry("additionalProp2", "string"),
 *                 Map.entry("additionalProp3", "string")
 *             ))
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:FhirService fhirservice1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/fhirservices/{fhirServiceName}
 * ```
 * @property accessPolicies Fhir Service access policies.
 * @property acrConfiguration Fhir Service Azure container registry configuration.
 * @property authenticationConfiguration Fhir Service authentication configuration.
 * @property corsConfiguration Fhir Service Cors configuration.
 * @property exportConfiguration Fhir Service export configuration.
 * @property fhirServiceName The name of FHIR Service resource.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property implementationGuidesConfiguration Implementation Guides configuration.
 * @property importConfiguration Fhir Service import configuration.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceVersionPolicyConfiguration Determines tracking of history for resources.
 * @property tags Resource tags.
 * @property workspaceName The name of workspace resource.
 */
public data class FhirServiceArgs(
    public val accessPolicies: Output<List<FhirServiceAccessPolicyEntryArgs>>? = null,
    public val acrConfiguration: Output<FhirServiceAcrConfigurationArgs>? = null,
    public val authenticationConfiguration: Output<FhirServiceAuthenticationConfigurationArgs>? =
        null,
    public val corsConfiguration: Output<FhirServiceCorsConfigurationArgs>? = null,
    public val exportConfiguration: Output<FhirServiceExportConfigurationArgs>? = null,
    public val fhirServiceName: Output<String>? = null,
    public val identity: Output<ServiceManagedIdentityIdentityArgs>? = null,
    public val implementationGuidesConfiguration: Output<ImplementationGuidesConfigurationArgs>? =
        null,
    public val importConfiguration: Output<FhirServiceImportConfigurationArgs>? = null,
    public val kind: Output<Either<String, FhirServiceKind>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceVersionPolicyConfiguration: Output<ResourceVersionPolicyConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.FhirServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.FhirServiceArgs =
        com.pulumi.azurenative.healthcareapis.FhirServiceArgs.builder()
            .accessPolicies(
                accessPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .acrConfiguration(acrConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .corsConfiguration(corsConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .exportConfiguration(
                exportConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fhirServiceName(fhirServiceName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .implementationGuidesConfiguration(
                implementationGuidesConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .importConfiguration(
                importConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceVersionPolicyConfiguration(
                resourceVersionPolicyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FhirServiceArgs].
 */
@PulumiTagMarker
public class FhirServiceArgsBuilder internal constructor() {
    private var accessPolicies: Output<List<FhirServiceAccessPolicyEntryArgs>>? = null

    private var acrConfiguration: Output<FhirServiceAcrConfigurationArgs>? = null

    private var authenticationConfiguration: Output<FhirServiceAuthenticationConfigurationArgs>? =
        null

    private var corsConfiguration: Output<FhirServiceCorsConfigurationArgs>? = null

    private var exportConfiguration: Output<FhirServiceExportConfigurationArgs>? = null

    private var fhirServiceName: Output<String>? = null

    private var identity: Output<ServiceManagedIdentityIdentityArgs>? = null

    private var implementationGuidesConfiguration: Output<ImplementationGuidesConfigurationArgs>? =
        null

    private var importConfiguration: Output<FhirServiceImportConfigurationArgs>? = null

    private var kind: Output<Either<String, FhirServiceKind>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceVersionPolicyConfiguration: Output<ResourceVersionPolicyConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Fhir Service access policies.
     */
    @JvmName("xysvnjhajprbntme")
    public suspend fun accessPolicies(`value`: Output<List<FhirServiceAccessPolicyEntryArgs>>) {
        this.accessPolicies = value
    }

    @JvmName("gvugkfujuaxbmilp")
    public suspend fun accessPolicies(vararg values: Output<FhirServiceAccessPolicyEntryArgs>) {
        this.accessPolicies = Output.all(values.asList())
    }

    /**
     * @param values Fhir Service access policies.
     */
    @JvmName("uumtfxudlmlwucqu")
    public suspend fun accessPolicies(values: List<Output<FhirServiceAccessPolicyEntryArgs>>) {
        this.accessPolicies = Output.all(values)
    }

    /**
     * @param value Fhir Service Azure container registry configuration.
     */
    @JvmName("oasvuxolnnluowjh")
    public suspend fun acrConfiguration(`value`: Output<FhirServiceAcrConfigurationArgs>) {
        this.acrConfiguration = value
    }

    /**
     * @param value Fhir Service authentication configuration.
     */
    @JvmName("kkqerbucrtuojvyi")
    public suspend
    fun authenticationConfiguration(`value`: Output<FhirServiceAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value Fhir Service Cors configuration.
     */
    @JvmName("wjlsllafevlqpfel")
    public suspend fun corsConfiguration(`value`: Output<FhirServiceCorsConfigurationArgs>) {
        this.corsConfiguration = value
    }

    /**
     * @param value Fhir Service export configuration.
     */
    @JvmName("knxjjgwqfeghqyjm")
    public suspend fun exportConfiguration(`value`: Output<FhirServiceExportConfigurationArgs>) {
        this.exportConfiguration = value
    }

    /**
     * @param value The name of FHIR Service resource.
     */
    @JvmName("tomyidgdktykrjdr")
    public suspend fun fhirServiceName(`value`: Output<String>) {
        this.fhirServiceName = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("pyjclmeautqthinw")
    public suspend fun identity(`value`: Output<ServiceManagedIdentityIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Implementation Guides configuration.
     */
    @JvmName("kvsgfaboguknlcrg")
    public suspend
    fun implementationGuidesConfiguration(`value`: Output<ImplementationGuidesConfigurationArgs>) {
        this.implementationGuidesConfiguration = value
    }

    /**
     * @param value Fhir Service import configuration.
     */
    @JvmName("wllcxwkqtgqxxybi")
    public suspend fun importConfiguration(`value`: Output<FhirServiceImportConfigurationArgs>) {
        this.importConfiguration = value
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("koymmjopslbnsoyw")
    public suspend fun kind(`value`: Output<Either<String, FhirServiceKind>>) {
        this.kind = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ulcwvnsucdyogfhd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("slqqksajhwdfggkr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Determines tracking of history for resources.
     */
    @JvmName("mtktbohdeijynatx")
    public suspend
    fun resourceVersionPolicyConfiguration(`value`: Output<ResourceVersionPolicyConfigurationArgs>) {
        this.resourceVersionPolicyConfiguration = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("emsnnasgytnwwgid")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("twxqxaravajfqlff")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Fhir Service access policies.
     */
    @JvmName("rywijcnuvnunmyrl")
    public suspend fun accessPolicies(`value`: List<FhirServiceAccessPolicyEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param argument Fhir Service access policies.
     */
    @JvmName("qcuppsnedivgsaxm")
    public suspend
    fun accessPolicies(argument: List<suspend FhirServiceAccessPolicyEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FhirServiceAccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument Fhir Service access policies.
     */
    @JvmName("nqumebxobwlgxijm")
    public suspend fun accessPolicies(
        vararg
        argument: suspend FhirServiceAccessPolicyEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FhirServiceAccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument Fhir Service access policies.
     */
    @JvmName("tdnujmolqawsasvx")
    public suspend
    fun accessPolicies(argument: suspend FhirServiceAccessPolicyEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FhirServiceAccessPolicyEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param values Fhir Service access policies.
     */
    @JvmName("jvshlfrrhjabgbwb")
    public suspend fun accessPolicies(vararg values: FhirServiceAccessPolicyEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Fhir Service Azure container registry configuration.
     */
    @JvmName("gkhpntagftwxqmpp")
    public suspend fun acrConfiguration(`value`: FhirServiceAcrConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrConfiguration = mapped
    }

    /**
     * @param argument Fhir Service Azure container registry configuration.
     */
    @JvmName("amjoeywlsqqnbiku")
    public suspend
    fun acrConfiguration(argument: suspend FhirServiceAcrConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FhirServiceAcrConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.acrConfiguration = mapped
    }

    /**
     * @param value Fhir Service authentication configuration.
     */
    @JvmName("mbdfclomjjhmfoyp")
    public suspend
    fun authenticationConfiguration(`value`: FhirServiceAuthenticationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument Fhir Service authentication configuration.
     */
    @JvmName("hflgmpyuxesptbwj")
    public suspend
    fun authenticationConfiguration(argument: suspend FhirServiceAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FhirServiceAuthenticationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value Fhir Service Cors configuration.
     */
    @JvmName("jrmjyelkkjxmofee")
    public suspend fun corsConfiguration(`value`: FhirServiceCorsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfiguration = mapped
    }

    /**
     * @param argument Fhir Service Cors configuration.
     */
    @JvmName("xbysycyvdyqoblky")
    public suspend
    fun corsConfiguration(argument: suspend FhirServiceCorsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FhirServiceCorsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfiguration = mapped
    }

    /**
     * @param value Fhir Service export configuration.
     */
    @JvmName("coupytnitxhfnftd")
    public suspend fun exportConfiguration(`value`: FhirServiceExportConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportConfiguration = mapped
    }

    /**
     * @param argument Fhir Service export configuration.
     */
    @JvmName("kvikcnsbaymlcoip")
    public suspend
    fun exportConfiguration(argument: suspend FhirServiceExportConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FhirServiceExportConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportConfiguration = mapped
    }

    /**
     * @param value The name of FHIR Service resource.
     */
    @JvmName("kvxiqqrpfkfwkuhk")
    public suspend fun fhirServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fhirServiceName = mapped
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("eytqeeijiihjrrra")
    public suspend fun identity(`value`: ServiceManagedIdentityIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("udafikvffgpwvkoi")
    public suspend
    fun identity(argument: suspend ServiceManagedIdentityIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceManagedIdentityIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Implementation Guides configuration.
     */
    @JvmName("qkofuhwelonaethv")
    public suspend
    fun implementationGuidesConfiguration(`value`: ImplementationGuidesConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.implementationGuidesConfiguration = mapped
    }

    /**
     * @param argument Implementation Guides configuration.
     */
    @JvmName("uaymakqlqnlxjkff")
    public suspend
    fun implementationGuidesConfiguration(argument: suspend ImplementationGuidesConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImplementationGuidesConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.implementationGuidesConfiguration = mapped
    }

    /**
     * @param value Fhir Service import configuration.
     */
    @JvmName("punrfsvivaotcbvy")
    public suspend fun importConfiguration(`value`: FhirServiceImportConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importConfiguration = mapped
    }

    /**
     * @param argument Fhir Service import configuration.
     */
    @JvmName("dllhvangaiacijpe")
    public suspend
    fun importConfiguration(argument: suspend FhirServiceImportConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FhirServiceImportConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.importConfiguration = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("bfxmcvlwwmtdwlqt")
    public suspend fun kind(`value`: Either<String, FhirServiceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("ephafpseagjmrgck")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FhirServiceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("ogecwrwyvejwpjoq")
    public fun kind(`value`: FhirServiceKind) {
        val toBeMapped = Either.ofRight<String, FhirServiceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("hxsdwhsrbjannwvj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("rbsgcldvvlgvwvel")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Determines tracking of history for resources.
     */
    @JvmName("qqeciijsbhapkuat")
    public suspend
    fun resourceVersionPolicyConfiguration(`value`: ResourceVersionPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceVersionPolicyConfiguration = mapped
    }

    /**
     * @param argument Determines tracking of history for resources.
     */
    @JvmName("aekcotfxbpovvexu")
    public suspend
    fun resourceVersionPolicyConfiguration(argument: suspend ResourceVersionPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceVersionPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resourceVersionPolicyConfiguration = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("njrhjnxwrisplybp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("efbkbhqrnafdbcah")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("ypbtwrbnaigxrieq")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FhirServiceArgs = FhirServiceArgs(
        accessPolicies = accessPolicies,
        acrConfiguration = acrConfiguration,
        authenticationConfiguration = authenticationConfiguration,
        corsConfiguration = corsConfiguration,
        exportConfiguration = exportConfiguration,
        fhirServiceName = fhirServiceName,
        identity = identity,
        implementationGuidesConfiguration = implementationGuidesConfiguration,
        importConfiguration = importConfiguration,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceVersionPolicyConfiguration = resourceVersionPolicyConfiguration,
        tags = tags,
        workspaceName = workspaceName,
    )
}
